<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="xml" encoding="UTF-8"/>
	<!--	<xsl:key name="globalElements" match="/xs:schema/xs:element[@name!='Document']" use="@name"/>-->
	<!--
	Zaczynamy pracę
	-->
	<xsl:template match="/">
		<xsl:element name="formList">
			<xsl:apply-templates select="/xs:schema/xs:complexType[xs:complexContent/node()/@base='DocumentType']" mode="processDocumentType"/>
		</xsl:element>
	</xsl:template>
	<!--
	
	-->
	<xsl:template match="/xs:schema/xs:complexType" mode="processDocumentType">
		<xsl:element name="form">
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:apply-templates select="xs:annotation/xs:documentation[@source='displayName' and @xml:lang='pl']" mode="processDocumentation"/>
			<xsl:apply-templates select="xs:annotation/xs:documentation[@source='helpText' and @xml:lang='pl']" mode="processDocumentation"/>
			<xsl:choose>
				<xsl:when test="string-length(xs:complexContent/xs:extension/@base)>0">
					<xsl:apply-templates select="/xs:schema/xs:complexType[@name='DocumentType']/xs:sequence/xs:element" mode="processFields"/>
					<xsl:apply-templates select="xs:complexContent/xs:extension/xs:sequence/xs:element" mode="processFields"/>
				</xsl:when>
				<xsl:when test="string-length(xs:complexContent/xs:restriction/@base)>0">
					<xsl:apply-templates select="xs:complexContent/xs:restriction/xs:sequence/xs:element" mode="processFields"/>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<!--
	
	-->
	<xsl:template match="child::xs:element" mode="processFields">
		<xsl:choose>
			<xsl:when test="string-length(@name)>0">
				<xsl:call-template name="processField"/>
			</xsl:when>
			<xsl:when test="string-length(@ref)>0">
				<xsl:variable name="reference" select="@ref"/>
				<xsl:apply-templates select="//xs:element[@name=$reference]" mode="processField"/>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<!--
	
	-->
	<xsl:template match="//xs:element" mode="processField" name="processField">
		<xsl:element name="field">
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="type"><xsl:call-template name="getType"/></xsl:attribute>
			<xsl:apply-templates select="xs:annotation/xs:documentation[@source='displayName' and @xml:lang='pl']" mode="processDocumentation"/>
			<xsl:apply-templates select="xs:annotation/xs:documentation[@source='helpText' and @xml:lang='pl']" mode="processDocumentation"/>
			<xsl:apply-templates select="xs:annotation/xs:appinfo[@source='hidden']" mode="processAppinfo"/>
			<xsl:apply-templates select="xs:annotation/xs:appinfo[@source='emptyValue']" mode="processAppinfo"/>
		</xsl:element>
	</xsl:template>
	<!--
	
	-->
	<xsl:template name="getType">
		<xsl:choose>
			<xsl:when test="string-length(@type)>0">
				<xsl:value-of select="@type"/>
			</xsl:when>
			<xsl:when test="string-length(node()/xs:extension/@base)>0">
				<xsl:value-of select="node()/xs:extension/@base"/>
			</xsl:when>
			<xsl:when test="string-length(node()/xs:restriction/@base)>0">
				<xsl:value-of select="node()/xs:restriction/@base"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--

	-->
	<xsl:template match="//xs:documentation" mode="processDocumentation" name="processDocumentation">
		<xsl:choose>
			<xsl:when test="string-length(.)>0">
				<xsl:attribute name="{./@source}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--

	-->
	<xsl:template match="//xs:appinfo" mode="processAppinfo" name="processAppinfo">
		<xsl:choose>
			<xsl:when test="string-length(.)>0">
				<xsl:attribute name="{./@source}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
