<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:param name="indent" select="'&#x20;&#x20;'"/>
    <xsl:param name="newline" select="'&#xA;'"/>
    <xsl:output method="html" encoding="utf-8" indent="yes"/>

    <xsl:template match="node()|@*">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="comment()">
        <xsl:copy>
            <xsl:apply-templates select="comment()"/>
        </xsl:copy>
        <xsl:call-template name="newLine"/>
    </xsl:template>

    <xsl:template match="TaggedPDF-doc">
        <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;&#xA;</xsl:text>
        <html>
            <body>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="Document">
        <!--Ignore Document and just bring through the contents as it should surround the complete document but is not always present-->
        <!--Instead we use TaggedPDF-doc to create the html and body tags as it is always present and ignore Document-->
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="H1|H|Heading">
        <h1><xsl:apply-templates/></h1>
    </xsl:template>

    <xsl:template match="H2">
        <h2><xsl:apply-templates/></h2>
    </xsl:template>

    <xsl:template match="H3">
        <h3><xsl:apply-templates/></h3>
    </xsl:template>

    <xsl:template match="H4">
        <h4><xsl:apply-templates/></h4>
    </xsl:template>

    <xsl:template match="H5">
        <h5><xsl:apply-templates/></h5>
    </xsl:template>

    <xsl:template match="H6">
        <h6><xsl:apply-templates/></h6>
    </xsl:template>

    <xsl:template match="P|Paragraph">
        <xsl:choose>
            <xsl:when test="not(string(.))">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="parent::TR">
                <td><xsl:apply-templates/></td>
            </xsl:when>
            <xsl:when test="parent::TD">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="parent::Table">
                <tr><td><xsl:apply-templates/></td></tr>
            </xsl:when>
            <xsl:when test="parent::P|parent::Paragraph">
                <br/><xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
                <p><xsl:apply-templates/></p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="Span|Index">
        <span><xsl:apply-templates/></span>
    </xsl:template>

    <xsl:template match="Link">
        <a><xsl:apply-templates/></a>
    </xsl:template>

    <xsl:template match="Figure">
        <figure><xsl:apply-templates/></figure>
    </xsl:template>

    <xsl:template match="Sect|Section|Part">
        <section><xsl:apply-templates/></section>
    </xsl:template>

    <xsl:template match="Article|Art">
        <article><xsl:apply-templates/></article>
    </xsl:template>

    <xsl:template match="Table">
        <table><xsl:apply-templates/></table>
    </xsl:template>

    <xsl:template match="TR">
        <tr><xsl:apply-templates/></tr>
    </xsl:template>

    <xsl:template match="TH">
        <th><xsl:apply-templates/></th>
    </xsl:template>

    <xsl:template match="TD">
        <xsl:choose>
            <xsl:when test="count(../preceding-sibling::TR) = 0">
                <th><xsl:apply-templates/></th>
            </xsl:when>
            <xsl:otherwise>
                <td><xsl:apply-templates/></td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="THead">
        <thead><xsl:apply-templates/></thead>
    </xsl:template>

    <xsl:template match="TBody">
        <tbody><xsl:apply-templates/></tbody>
    </xsl:template>

    <xsl:template match="TFoot">
        <tfoot><xsl:apply-templates/></tfoot>
    </xsl:template>

    <xsl:template match="L|List">
        <xsl:choose>
            <xsl:when test="parent::L|parent::List">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
                <ul><xsl:apply-templates/></ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="LI">
        <xsl:choose>
            <xsl:when test="./Lbl">
                <xsl:param name="bulletStyle" select="./Lbl"/>
                <li style="list-style-type:'{$bulletStyle}'">
                <xsl:apply-templates/>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li><xsl:apply-templates/></li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="LBody">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="Lbl">
        <!--Lbl is picked up by a parent LI and added as a style so we should not transform this value when found-->
    </xsl:template>

    <xsl:template match="TOC">
        <ul><xsl:apply-templates/></ul>
    </xsl:template>

    <xsl:template match="TOCI">
        <li><xsl:apply-templates/></li>
    </xsl:template>

    <xsl:template match="Div|Division">
        <div><xsl:apply-templates/></div>
    </xsl:template>

    <xsl:template match="BlockQuote">
        <blockquote><xsl:apply-templates/></blockquote>
    </xsl:template>

    <xsl:template match="Quote|Quotation">
        <q><xsl:apply-templates/></q>
    </xsl:template>

    <xsl:template match="Caption">
        <caption><xsl:apply-templates/></caption>
    </xsl:template>

    <xsl:template match="Reference">
        <cite><xsl:apply-templates/></cite>
    </xsl:template>

    <xsl:template match="Code">
        <code><xsl:apply-templates/></code>
    </xsl:template>

    <xsl:template match="Ruby|Warichu">
        <ruby><xsl:apply-templates/></ruby>
    </xsl:template>

    <xsl:template match="RB">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="RT|WT">
        <rt><xsl:apply-templates/></rt>
    </xsl:template>

    <xsl:template match="RP|WP">
        <rp><xsl:apply-templates/></rp>
    </xsl:template>

    <xsl:template match="NonStruct|Private">
        <!-- This type should not be exported -->
    </xsl:template>

    <xsl:template match="Formula">
        <!-- This type should not be exported -->
        <math><xsl:apply-templates/></math>
    </xsl:template>

    <xsl:template match="Note">
        <!-- This type should not be exported -->
        <footer><xsl:apply-templates/></footer>
    </xsl:template>

    <xsl:template match="BibEntry">
        <!-- This type should not be exported -->
        <cite><xsl:apply-templates/></cite>
    </xsl:template>


    <xsl:template name="newLine">
        <xsl:value-of select="$newline"/>
    </xsl:template>

    <xsl:template name="indent">
        <xsl:param name="indent-sum"/>
        <!-- Indent begin tag. -->
        <xsl:value-of select="$indent-sum"/>
        <xsl:if test="count(node())">
                <xsl:with-param name="indent-sum"
                                select="concat($indent, $indent-sum)"/>
            <xsl:if test="count(node()) > count(text())">
                <!-- Indent end tag. -->
                <xsl:value-of select="$indent-sum"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

<!--To be Added fined in PDF spec, section 10.7.3-->
<!--Annot - association between document and an annotation-->
<!--Link Elements - Link elements are defined in realtion to annotations, need to determine how the XML appears before doing more-->
<!--Annotation Elements - Link elements are defined in realtion to annotations, need to determine how the XML appears before doing more-->
<!--Form - A widget annotation representing in interactive form field-->
</xsl:stylesheet>