/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import net.miginfocom.swing.MigLayout;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;
import pl.gov.mofnet.giif.signencrypt.gui.GUIUtils;
import pl.gov.mofnet.giif.signencrypt.gui.Msg;

public class SignDialog
extends JPanel {
    public static final String ENCRYPTED_FILE_SUFFIX = ".zaszyfrowany";
    final JLabel sourceLbl;
    final JTextField sourceTxt;
    final JButton sourceBtn;
    final JLabel destinationLbl;
    final JTextField destinationTxt;
    final JButton destinationBtn;
    final JCheckBox overwriteChkBox;
    final JFileChooser fileChooser;
    private File sourceFile;
    private File destinationFile;

    public SignDialog() {
        super(new MigLayout("", "[][fill,grow][]", "[]"));
        this.setPreferredSize(new Dimension(640, 120));
        this.setMinimumSize(new Dimension(640, 0));
        this.sourceLbl = new JLabel(Msg.getString("SOURCE_FILE_LABEL"));
        this.sourceTxt = new JTextField();
        GUIUtils.addChangeListener(this.sourceTxt, this::editSourceText);
        this.sourceBtn = new JButton("...");
        this.sourceBtn.addActionListener(this::chooseSourceFile);
        this.destinationLbl = new JLabel(Msg.getString("DESTINATION_FILE_LABEL"));
        this.destinationTxt = new JTextField();
        GUIUtils.addChangeListener(this.destinationTxt, this::editDestinationText);
        this.destinationBtn = new JButton("...");
        this.destinationBtn.addActionListener(this::chooseDestinationFile);
        this.overwriteChkBox = new JCheckBox(Msg.getString("ALLOW_OVERWRITE_CHKBOX"));
        this.overwriteChkBox.setEnabled(false);
        this.fileChooser = new JFileChooser();
        this.add(this.sourceLbl);
        this.add((Component)this.sourceTxt, "growx");
        this.add((Component)this.sourceBtn, "wrap");
        this.add(this.destinationLbl);
        this.add((Component)this.destinationTxt, "growx");
        this.add((Component)this.destinationBtn, "wrap");
        this.add((Component)this.overwriteChkBox, "skip, growx");
    }

    public static SignDialog showDialog(Frame parent) {
        SignDialog panel = new SignDialog();
        int confirmDialog = JOptionPane.showConfirmDialog(parent, panel, Msg.getString("SIGN_DIALOG_TITLE"), 2, -1, null);
        if (confirmDialog == 0) {
            return panel;
        }
        return null;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    private void chooseSourceFile(ActionEvent actionEvent) {
        int dialogResult = this.fileChooser.showOpenDialog(this.getParent());
        if (dialogResult == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            if (this.destinationFile == null) {
                File parentFolder = selectedFile.getParentFile();
                String basename = FileSystemUtils.getBaseName(selectedFile);
                String encryptedName = basename + ENCRYPTED_FILE_SUFFIX;
                this.destinationFile = new File(parentFolder, encryptedName);
                this.destinationTxt.setText(this.destinationFile.getPath());
                this.checkDestinationFile();
            }
            if (!this.sameFile(selectedFile, this.destinationFile)) {
                this.sourceFile = selectedFile;
                this.sourceTxt.setText(this.sourceFile.getPath());
            }
        }
    }

    private void editSourceText(ChangeEvent actionEvent) {
        File textBoxFile = new File(this.sourceTxt.getText());
        if (textBoxFile.exists()) {
            this.sourceTxt.setForeground(UIManager.getColor("TextField.foreground"));
        } else {
            this.sourceTxt.setForeground(new Color(15407159));
        }
        if (!this.sameFile(textBoxFile, this.destinationFile)) {
            this.sourceFile = textBoxFile;
        }
    }

    private void editDestinationText(ChangeEvent actionEvent) {
        File textBoxFile = new File(this.destinationTxt.getText());
        if (!this.sameFile(this.sourceFile, textBoxFile)) {
            this.destinationFile = textBoxFile;
            this.checkDestinationFile();
        }
    }

    private void chooseDestinationFile(ActionEvent actionEvent) {
        File selectedFile;
        int dialogResult = this.fileChooser.showSaveDialog(this.getParent());
        if (dialogResult == 0 && !this.sameFile(this.sourceFile, selectedFile = this.fileChooser.getSelectedFile())) {
            this.destinationFile = selectedFile;
            this.checkDestinationFile();
            this.destinationTxt.setText(this.destinationFile.getPath());
        }
    }

    private void checkDestinationFile() {
        if (this.destinationFile.exists()) {
            this.overwriteChkBox.setEnabled(true);
        } else {
            this.overwriteChkBox.setEnabled(false);
        }
    }

    private boolean sameFile(File source, File destination) {
        try {
            if (source != null && destination != null && Files.isSameFile(source.toPath(), destination.toPath())) {
                JOptionPane.showMessageDialog(null, "Nie mo\u017cna nadpisa\u0107 pliku \u017ar\u00f3d\u0142owego.", "Ostrze\u017cenie.", 0);
                return true;
            }
            return false;
        }
        catch (IOException e2) {
            return false;
        }
    }
}

