/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoUtils;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapper;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperException;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperFactory;
import pl.gov.mofnet.giif.signencrypt.crypto.FilePair;
import pl.gov.mofnet.giif.signencrypt.gui.Msg;
import pl.gov.mofnet.giif.signencrypt.gui.SignDialog;

public class MainDashboard
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(MainDashboard.class);
    private static final Color MIN_FIN_RED = new Color(15407159);
    private static final String APP_ICON_RESOURCE = "washing-machine.png";
    private static final String MIN_FIN_LOGO_RESOURCE = "logo_mf.png";
    private static final String SIGN_ICON_RESOURCE = "contract-128.png";
    private static final String SETTINGS_ICON_RESOURCE = "settings-128.png";
    private static final String LOADER_ICON_RESOURCE = "loader.gif";

    public MainDashboard() throws HeadlessException {
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(640, 400));
        this.setContentPane(this.createOuterPanel());
        try {
            ImageIcon appIcon = new ImageIcon(FileSystemUtils.readResourceToBytes(MainDashboard.class, APP_ICON_RESOURCE));
            this.setIconImage(appIcon.getImage());
        }
        catch (IOException e2) {
            log.warn("Cannot read application icon from resource washing-machine.png", e2);
        }
        this.pack();
    }

    private JPanel createHeader() {
        JPanel header = new JPanel(new MigLayout());
        header.setBackground(MIN_FIN_RED);
        JLabel minFinImageLabel = new JLabel();
        minFinImageLabel.setBackground(MIN_FIN_RED);
        try {
            ImageIcon minFinLogo = new ImageIcon(FileSystemUtils.readResourceToBytes(MainDashboard.class, MIN_FIN_LOGO_RESOURCE));
            minFinImageLabel.setIcon(minFinLogo);
        }
        catch (IOException e2) {
            log.warn("Cannot read application logo from resource logo_mf.png", e2);
        }
        minFinImageLabel.setOpaque(true);
        JLabel giifTextLabel = new JLabel(Msg.getString("GIIF_FULL_NAME"));
        Font font = giifTextLabel.getFont();
        Font logoFont = new Font(font.getName(), 1, 22);
        giifTextLabel.setBackground(MIN_FIN_RED);
        giifTextLabel.setForeground(Color.WHITE);
        giifTextLabel.setFont(logoFont);
        giifTextLabel.setOpaque(true);
        header.add(minFinImageLabel);
        header.add((Component)giifTextLabel, "growx, align right");
        return header;
    }

    private JPanel createInnerPanel() {
        JPanel innerPanel = new JPanel(new MigLayout("al center center, gapy 0", "[al center]", "[al center]"));
        innerPanel.setBackground(Color.WHITE);
        JButton sign = new JButton();
        try {
            ImageIcon signIcon = new ImageIcon(FileSystemUtils.readResourceToBytes(MainDashboard.class, SIGN_ICON_RESOURCE));
            sign.setIcon(signIcon);
        }
        catch (IOException e2) {
            log.warn("Cannot read sign icon from resource contract-128.png", e2);
        }
        sign.setText(Msg.getString("SIGN_ENCRYPT_BTN"));
        sign.setVerticalTextPosition(3);
        sign.setHorizontalTextPosition(0);
        sign.addActionListener(this::signFile);
        innerPanel.add(sign);
        return innerPanel;
    }

    private void signFile(ActionEvent actionEvent) {
        MainDashboard.setEventSourceIcon(actionEvent, LOADER_ICON_RESOURCE);
        SignDialog signDialog = SignDialog.showDialog(this);
        if (signDialog != null) {
            if (signDialog.getDestinationFile().exists() && !signDialog.overwriteChkBox.isSelected()) {
                MainDashboard.setEventSourceIcon(actionEvent, SIGN_ICON_RESOURCE);
                JOptionPane.showMessageDialog(this, Msg.getString("OVERWRITE_DISABLED"), Msg.getString("SIGN_FAILURE_TITLE"), 2);
                return;
            }
            CryptoWrapper cryptoWrapper = CryptoWrapperFactory.getCryptoWraper();
            List<FilePair> filesToEncrypt = Collections.singletonList(cryptoWrapper.createFilePair(signDialog.getSourceFile(), signDialog.getDestinationFile()));
            List<X509Certificate> encryptionCertificate = Collections.singletonList(CryptoUtils.getDefaultEncryptionCertificate());
            new Thread(() -> {
                try {
                    List<FilePair> filePairs = cryptoWrapper.signEncrypt(filesToEncrypt, encryptionCertificate);
                    SwingUtilities.invokeLater(() -> {
                        MainDashboard.setEventSourceIcon(actionEvent, SIGN_ICON_RESOURCE);
                        JOptionPane.showMessageDialog(this, filePairs.stream().map(FilePair::getOutput).map(File::toString).collect(Collectors.joining("\n")), Msg.getString("SIGN_SUCCESS_TITLE"), 1);
                    });
                }
                catch (CryptoWrapperException ex) {
                    SwingUtilities.invokeLater(() -> {
                        MainDashboard.setEventSourceIcon(actionEvent, SIGN_ICON_RESOURCE);
                        if (ex.getCause() == null) {
                            JOptionPane.showMessageDialog(this, ex.getMessage(), Msg.getString("SIGN_FAILURE_TITLE"), 0);
                        } else if (Msg.exceptionDialog(this, Msg.getString("SIGN_FAILURE_TITLE"), ex)) {
                            System.exit(2);
                        }
                    });
                }
            }).start();
        } else {
            MainDashboard.setEventSourceIcon(actionEvent, SIGN_ICON_RESOURCE);
        }
    }

    private static void setEventSourceIcon(ActionEvent actionEvent, String iconResource) {
        try {
            Object source = actionEvent.getSource();
            if (source instanceof JButton) {
                JButton jb = (JButton)source;
                ImageIcon loaderIcon = new ImageIcon(FileSystemUtils.readResourceToBytes(MainDashboard.class, iconResource));
                jb.setIcon(loaderIcon);
            }
        }
        catch (IOException ex) {
            log.warn("Cannot read loading icon from resource " + iconResource, ex);
        }
    }

    private JPanel createOuterPanel() {
        JPanel panel = new JPanel(new MigLayout("", "[fill]", "[][fill,grow]"));
        panel.add((Component)this.createHeader(), "wrap");
        panel.add(this.createInnerPanel());
        return panel;
    }
}

