/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.gui;

import java.util.Objects;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtils {
    private static final Logger log = LoggerFactory.getLogger(GUIUtils.class);

    public static void addChangeListener(final JTextComponent text, final ChangeListener changeListener) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(changeListener);
        DocumentListener dl = new DocumentListener(){
            private int lastChange = 0;
            private int lastNotifiedChange = 0;

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.changedUpdate(e2);
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.changedUpdate(e2);
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                ++this.lastChange;
                SwingUtilities.invokeLater(() -> {
                    if (this.lastNotifiedChange != this.lastChange) {
                        this.lastNotifiedChange = this.lastChange;
                        changeListener.stateChanged(new ChangeEvent(text));
                    }
                });
            }
        };
        text.addPropertyChangeListener("document", e2 -> {
            Document d1 = (Document)e2.getOldValue();
            Document d2 = (Document)e2.getNewValue();
            if (d1 != null) {
                d1.removeDocumentListener(dl);
            }
            if (d2 != null) {
                d2.addDocumentListener(dl);
            }
            dl.changedUpdate(null);
        });
        Document d2 = text.getDocument();
        if (d2 != null) {
            d2.addDocumentListener(dl);
        }
    }
}

