/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.crypto.szafir;

import java.io.StringWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperConfigurationException;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.CachedTaskListContext;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.SzafirFilePair;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.EncryptingProperties;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.EncryptingTask;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.ObjectFactory;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.SigningTaskItemType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.SigningTaskType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.TaskListType;

public class TaskFileBuilder {
    private static final ObjectFactory TASK_LIST_OBJECT_FACTORY = new ObjectFactory();
    private final TaskListType taskList = TASK_LIST_OBJECT_FACTORY.createTaskListType();

    public TaskFileBuilder addItemsToSign(List<SzafirFilePair> itemsToSign) {
        SigningTaskType signingTask = this.getSigningTask();
        itemsToSign.stream().map(TaskFileBuilder::convertToSigningTaskItem).collect(Collectors.toCollection(signingTask::getSigningTaskItemOrPKCS7ParallelSigningItemOrXAdESCounterSigningItem));
        return this;
    }

    public TaskFileBuilder addItemsToEncrypt(List<SzafirFilePair> itemsToEncrypt, List<X509Certificate> recipientCertificates) {
        HashSet<byte[]> certificates = new HashSet<byte[]>(recipientCertificates.size());
        for (X509Certificate cert : recipientCertificates) {
            try {
                certificates.add(cert.getEncoded());
            }
            catch (CertificateEncodingException e2) {
                throw new CryptoWrapperConfigurationException("Cannot encode recipient certificate.");
            }
        }
        EncryptingTask encryptingTask = this.getEncryptingTask(certificates);
        itemsToEncrypt.stream().map(TaskFileBuilder::convertToEncryptingTaskItem).collect(Collectors.toCollection(encryptingTask::getEncryptingTaskItem));
        return this;
    }

    private EncryptingTask getEncryptingTask(Set<byte[]> certificates) {
        Optional<EncryptingTask> encryptingTask = this.taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().stream().filter(e2 -> e2 instanceof EncryptingTask).map(EncryptingTask.class::cast).filter(e2 -> this.sameRecepientList((EncryptingTask)e2, certificates)).findAny();
        return encryptingTask.orElseGet(() -> {
            EncryptingTask task = TASK_LIST_OBJECT_FACTORY.createEncryptingTask();
            EncryptingProperties encryptingProperties = TASK_LIST_OBJECT_FACTORY.createEncryptingProperties();
            encryptingProperties.setEncryptingAlgorithm("AES");
            encryptingProperties.setCompression(false);
            task.setEncryptingProperties(encryptingProperties);
            EncryptingTask.RecipientList recipients = TASK_LIST_OBJECT_FACTORY.createEncryptingTaskRecipientList();
            certificates.stream().map(c2 -> {
                EncryptingTask.RecipientList.RecipientCertificate rc = TASK_LIST_OBJECT_FACTORY.createEncryptingTaskRecipientListRecipientCertificate();
                rc.setBase64Binary((byte[])c2);
                return rc;
            }).collect(Collectors.toCollection(recipients::getRecipientCertificate));
            task.setRecipientList(recipients);
            this.taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().add(task);
            return task;
        });
    }

    private boolean sameRecepientList(EncryptingTask e2, Set<byte[]> certificates) {
        EncryptingTask.RecipientList recipientList = e2.getRecipientList();
        Set taskCertificates = recipientList.getRecipientCertificate().stream().map(EncryptingTask.RecipientList.RecipientCertificate::getBase64Binary).collect(Collectors.toSet());
        return taskCertificates.equals(certificates);
    }

    public String build() {
        try {
            JAXBElement<TaskListType> wrappedTaskList = TASK_LIST_OBJECT_FACTORY.createTaskList(this.taskList);
            Marshaller marshaller = CachedTaskListContext.getContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            StringWriter sw = new StringWriter();
            marshaller.marshal(wrappedTaskList, sw);
            return sw.toString();
        }
        catch (JAXBException ex) {
            throw new CryptoWrapperConfigurationException("Cannot marshal TaskList.", ex);
        }
    }

    private SigningTaskType getSigningTask() {
        Optional<SigningTaskType> signingTaskTypeOptional = this.taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().stream().filter(e2 -> e2 instanceof SigningTaskType).map(SigningTaskType.class::cast).findAny();
        return signingTaskTypeOptional.orElseGet(() -> {
            SigningTaskType signingTask = TASK_LIST_OBJECT_FACTORY.createSigningTaskType();
            signingTask.setFormat("CAdES-BES");
            signingTask.setDataEmbedding(true);
            this.taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().add(signingTask);
            return signingTask;
        });
    }

    private static SigningTaskItemType convertToSigningTaskItem(SzafirFilePair filePair) {
        SigningTaskItemType result = TASK_LIST_OBJECT_FACTORY.createSigningTaskItemType();
        result.setId(filePair.getSignTaskId());
        SigningTaskItemType.DataToSign dataToSign = new SigningTaskItemType.DataToSign();
        dataToSign.setURI(filePair.getInput().toURI().toString());
        result.setDataToSign(dataToSign);
        SigningTaskItemType.SignatureToCreate signatureToCreate = new SigningTaskItemType.SignatureToCreate();
        signatureToCreate.setURI(filePair.getTemporary().toURI().toString());
        result.setSignatureToCreate(signatureToCreate);
        return result;
    }

    private static EncryptingTask.EncryptingTaskItem convertToEncryptingTaskItem(SzafirFilePair fileLocations) {
        EncryptingTask.EncryptingTaskItem result = TASK_LIST_OBJECT_FACTORY.createEncryptingTaskEncryptingTaskItem();
        result.setId(fileLocations.getEncryptTaskId());
        EncryptingTask.EncryptingTaskItem.DataToEncrypt dataToEncrypt = TASK_LIST_OBJECT_FACTORY.createEncryptingTaskEncryptingTaskItemDataToEncrypt();
        dataToEncrypt.setURI(fileLocations.getTemporary().toURI().toString());
        result.setDataToEncrypt(dataToEncrypt);
        EncryptingTask.EncryptingTaskItem.EncryptedData encryptedData = TASK_LIST_OBJECT_FACTORY.createEncryptingTaskEncryptingTaskItemEncryptedData();
        encryptedData.setURI(fileLocations.getOutput().toURI().toString());
        result.setEncryptedData(encryptedData);
        return result;
    }
}

