/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.crypto.szafir;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;
import pl.gov.mofnet.giif.signencrypt.crypto.FilePair;

public class SzafirFilePair
implements FilePair {
    private final File input;
    private final File temporary;
    private final File output;
    private String signTaskId;
    private String encryptTaskId;

    public SzafirFilePair(File input, File output) {
        this.input = input;
        this.output = output;
        try {
            this.temporary = File.createTempFile(FileSystemUtils.getBaseName(input), ".signed");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create temporary file.", ex);
        }
        this.signTaskId = "ID" + UUID.randomUUID();
        this.encryptTaskId = "ID" + UUID.randomUUID();
    }

    @Override
    public File getInput() {
        return this.input;
    }

    public File getTemporary() {
        return this.temporary;
    }

    @Override
    public File getOutput() {
        return this.output;
    }

    public String getSignTaskId() {
        return this.signTaskId;
    }

    public String getEncryptTaskId() {
        return this.encryptTaskId;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SzafirFilePair)) {
            return false;
        }
        SzafirFilePair that = (SzafirFilePair)o2;
        return Objects.equals(this.input, that.input) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }
}

