/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.crypto.szafir;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.SystemUtils;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.com.kir.crypto.common.utils.EngineException;
import pl.com.kir.crypto.library.TaskProcessor;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapper;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperConfigurationException;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperExecutionException;
import pl.gov.mofnet.giif.signencrypt.crypto.FilePair;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.CachedTaskListContext;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.OperationResult;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.SzafirFilePair;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.TaskFileBuilder;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.EncryptingTask;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.SigningTaskItemType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.SigningTaskType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.tasklist.TaskListType;

public class SzafirCryptoWrapper
implements CryptoWrapper {
    private static final Logger log = LoggerFactory.getLogger(SzafirCryptoWrapper.class);
    private static final String SZAFIR_SETTINGS_WINDOWS_RESOURCE = "/szafir-sdk-windows-settings.xml";
    private static final String SZAFIR_SETTINGS_LINUX_RESOURCE = "/szafir-sdk-linux-settings.xml";
    private static final String SZAFIR_SETTINGS_MACOSX_RESOURCE = "/szafir-sdk-macosx-settings.xml";

    @Override
    public List<FilePair> signEncrypt(List<FilePair> filePairs, List<X509Certificate> recipients) {
        Map<String, OperationResult> encryptTaksResult;
        Map<String, OperationResult> signTaskResult;
        TaskProcessor tp;
        List<SzafirFilePair> szafirFilePairs = filePairs.stream().map(f2 -> f2 instanceof SzafirFilePair ? f2 : this.createFilePair(f2.getInput(), f2.getOutput())).map(SzafirFilePair.class::cast).collect(Collectors.toList());
        String szafirSettings = this.readSzafirSettings();
        String signTaskXml = new TaskFileBuilder().addItemsToSign(szafirFilePairs).build();
        try {
            log.trace("Using the following settings.xml:\n{}", (Object)szafirSettings);
            tp = new TaskProcessor(szafirSettings);
        }
        catch (EngineException e2) {
            throw new CryptoWrapperConfigurationException("Failed to initialize SZAFIR.", e2);
        }
        if (SzafirCryptoWrapper.shouldDisablePreview(filePairs)) {
            tp.setPreviewMode(0);
        }
        try {
            log.trace("Using the following task for signing:\n{}", (Object)signTaskXml);
            String signResultXml = tp.doTaskList(signTaskXml);
            log.trace("Recieved the folowing result from signing:\n{}", (Object)signResultXml);
            signTaskResult = this.getSignResults(signResultXml);
        }
        catch (Exception e3) {
            throw new CryptoWrapperExecutionException("Failed to sign documents.", e3);
        }
        List<SzafirFilePair> signedFilePairs = szafirFilePairs.stream().filter(sfp -> ((OperationResult)signTaskResult.get(sfp.getSignTaskId())).isSuccessful()).collect(Collectors.toList());
        if (signedFilePairs.isEmpty()) {
            Optional<String> message = szafirFilePairs.stream().filter(sfp -> !((OperationResult)signTaskResult.get(sfp.getSignTaskId())).isSuccessful()).map(sfp -> (OperationResult)signTaskResult.get(sfp.getSignTaskId())).map(OperationResult::getMessage).findAny();
            throw new CryptoWrapperExecutionException(message.orElse("No file was signed."));
        }
        signedFilePairs.stream().filter(SzafirCryptoWrapper::shouldCompress).forEach(SzafirCryptoWrapper::compress);
        String encryptTaskXml = new TaskFileBuilder().addItemsToEncrypt(signedFilePairs, recipients).build();
        try {
            log.trace("Using the following task for encryption:\n{}", (Object)encryptTaskXml);
            String encryptResultXml = tp.doTaskListNoWindow(encryptTaskXml);
            log.trace("Received the following result from encryption:\n{}", (Object)encryptResultXml);
            encryptTaksResult = this.getEncryptionResults(encryptResultXml);
        }
        catch (Exception e4) {
            throw new CryptoWrapperExecutionException("Failed to encrypt documents.", e4);
        }
        List encryptedFilePairs = signedFilePairs.stream().peek(sfp -> sfp.getTemporary().delete()).filter(sfp -> ((OperationResult)encryptTaksResult.get(sfp.getEncryptTaskId())).isSuccessful()).collect(Collectors.toList());
        if (encryptedFilePairs.isEmpty()) {
            throw new CryptoWrapperExecutionException(signTaskResult.values().stream().filter(or -> !or.isSuccessful()).map(OperationResult::getMessage).findAny().orElse("No file was encrypted."));
        }
        return encryptedFilePairs.stream().map(FilePair.class::cast).collect(Collectors.toList());
    }

    private static boolean shouldCompress(FilePair input) {
        String ext = FileSystemUtils.getExtension(input.getInput());
        if (ext == null) {
            return false;
        }
        switch (ext.toLowerCase()) {
            case ".xml": 
            case ".txt": 
            case ".csv": 
            case ".tsv": {
                return true;
            }
        }
        return false;
    }

    private static void compress(SzafirFilePair fp) {
        try {
            File compressedFile = File.createTempFile(FileSystemUtils.getBaseName(fp.getInput()), ".compressed");
            try (OutputStream os = Files.newOutputStream(compressedFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING);
                 InputStream is = Files.newInputStream(fp.getTemporary().toPath(), new OpenOption[0]);){
                CMSCompressedDataStreamGenerator cgen = new CMSCompressedDataStreamGenerator();
                cgen.setBufferSize(131072);
                try (OutputStream cos = cgen.open(PKCSObjectIdentifiers.signedData, os, new ZlibCompressor());){
                    FileSystemUtils.copy(is, cos, 131072);
                }
            }
            Files.move(compressedFile.toPath(), fp.getTemporary().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static boolean shouldDisablePreview(List<FilePair> input) {
        for (FilePair pair : input) {
            String e2;
            File in = pair.getInput();
            String ext = FileSystemUtils.getExtension(in);
            if (in.length() > 0xA00000L) {
                return true;
            }
            if (ext == null || !".zip".equals(e2 = ext.toLowerCase()) && !".rar".equals(e2) && !".7z".equals(e2) && !".tar".equals(e2) && !".tgz".equals(e2) && !".gz".equals(e2) && !".tbz2".equals(e2) && !".bz2".equals(e2) && !".txz".equals(e2) && !".xz".equals(e2)) continue;
            return true;
        }
        return false;
    }

    private String readSzafirSettings() {
        try {
            String szafirSettings;
            if (SystemUtils.IS_OS_WINDOWS) {
                szafirSettings = FileSystemUtils.readOverrideableResourceToString(SzafirCryptoWrapper.class, SZAFIR_SETTINGS_WINDOWS_RESOURCE);
            } else if (SystemUtils.IS_OS_LINUX) {
                szafirSettings = FileSystemUtils.readOverrideableResourceToString(SzafirCryptoWrapper.class, SZAFIR_SETTINGS_LINUX_RESOURCE);
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                szafirSettings = FileSystemUtils.readOverrideableResourceToString(SzafirCryptoWrapper.class, SZAFIR_SETTINGS_MACOSX_RESOURCE);
            } else {
                File file = new File(FileSystemUtils.getJarFolder(SzafirCryptoWrapper.class), "settings.xml");
                log.warn("Nieznany system operacyjny, odczytuj\u0119 ustawienia Szafir SDK z pliku {}", (Object)file);
                szafirSettings = FileSystemUtils.readFileToString(file);
            }
            if (szafirSettings == null || szafirSettings.isEmpty()) {
                throw new CryptoWrapperConfigurationException("Failed to read SZAFIR settings.");
            }
            return szafirSettings;
        }
        catch (IOException e2) {
            throw new CryptoWrapperConfigurationException("Failed to read SZAFIR settings.", e2);
        }
    }

    private TaskListType convertToTaskListType(String taskListXml) {
        try {
            Unmarshaller unmarshaller = CachedTaskListContext.getContext().createUnmarshaller();
            JAXBElement el = (JAXBElement)unmarshaller.unmarshal(new StringReader(taskListXml));
            return (TaskListType)el.getValue();
        }
        catch (JAXBException je) {
            throw new CryptoWrapperExecutionException("Cannot parse result.", je);
        }
    }

    private Map<String, OperationResult> getSignResults(String taskListXml) {
        TaskListType taskList = this.convertToTaskListType(taskListXml);
        return taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().stream().filter(o2 -> o2 instanceof SigningTaskType).map(SigningTaskType.class::cast).flatMap(st -> st.getSigningTaskItemOrPKCS7ParallelSigningItemOrXAdESCounterSigningItem().stream()).filter(o2 -> o2 instanceof SigningTaskItemType).map(SigningTaskItemType.class::cast).collect(Collectors.toMap(SigningTaskItemType::getId, sti -> new OperationResult(sti.getSigningResult().getResult(), sti.getSigningResult().getDescription())));
    }

    private Map<String, OperationResult> getEncryptionResults(String taskListXml) {
        TaskListType taskList = this.convertToTaskListType(taskListXml);
        return taskList.getSigningTaskOrVerifyingTaskOrTimeStampingTask().stream().filter(o2 -> o2 instanceof EncryptingTask).map(EncryptingTask.class::cast).flatMap(et -> et.getEncryptingTaskItem().stream()).collect(Collectors.toMap(EncryptingTask.EncryptingTaskItem::getId, eti -> new OperationResult(eti.getResult(), eti.getDescription())));
    }

    @Override
    public SzafirFilePair createFilePair(File input, File output) {
        return new SzafirFilePair(input, output);
    }
}

