/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.crypto.szafir;

import java.io.File;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.AlgorithmsType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.ApprovedCertificateType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.CACertificateType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.CryptoProviderType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.CryptoProvidersType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.HardwareProviderType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.LocalStoreType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.ObjectFactory;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.SettingsType;
import pl.gov.mofnet.giif.signencrypt.crypto.szafir.xsd.settings.SigningType;

public class Settings {
    private static final Logger log;
    private static final JAXBContext jaxbContext;
    private static final String PKCS11_TYPE_A = "PKCS#11 Type A";
    private ObjectFactory settingsObjectFactory = new ObjectFactory();
    private SettingsType settings = this.settingsObjectFactory.createSettingsType();

    public Settings() {
        this.qualifiedCertificatesOnly();
        this.chooseAlgorithms();
    }

    public String generateSettingsXml() throws JAXBException {
        JAXBElement<SettingsType> settingsJaxb = this.settingsObjectFactory.createSettings(this.settings);
        Marshaller marshaller = jaxbContext.createMarshaller();
        StringWriter sw = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(settingsJaxb, sw);
        return sw.toString();
    }

    public void appendCertificate(byte[] cert, String crlUrl) {
        CACertificateType newCertificate = this.settingsObjectFactory.createCACertificateType();
        newCertificate.setX509Certificate(cert);
        newCertificate.setCRLAddress(crlUrl);
        this.appendCertificate(newCertificate);
    }

    public void appendCertificate(CACertificateType caCertificate) {
        LocalStoreType localStore = this.settings.getLocalStore();
        if (localStore == null) {
            localStore = this.settingsObjectFactory.createLocalStoreType();
        }
        List<CACertificateType> caCertificates = localStore.getCACertificate();
        caCertificates.add(caCertificate);
        this.settings.setLocalStore(localStore);
    }

    public void appendPkcs11Library(String libraryFileName) {
        HardwareProviderType hardwareProvider = this.settingsObjectFactory.createHardwareProviderType();
        hardwareProvider.setName(PKCS11_TYPE_A);
        hardwareProvider.setURI(libraryFileName);
        this.addCryptoProvider(hardwareProvider);
    }

    public void appendPkcs11Library(File libraryFile) {
        this.appendPkcs11Library(libraryFile.toURI());
    }

    public void appendPkcs11Library(URI libraryURI) {
        this.appendPkcs11Library(libraryURI.toASCIIString());
    }

    private void addCryptoProvider(HardwareProviderType hardwareProvider) {
        CryptoProvidersType cryptoProviders = this.settings.getCryptoProviders();
        if (cryptoProviders == null) {
            cryptoProviders = this.settingsObjectFactory.createCryptoProvidersType();
        }
        List<CryptoProviderType> providers = cryptoProviders.getHardwareProviderOrSoftwareProvider();
        providers.add(hardwareProvider);
        this.settings.setCryptoProviders(cryptoProviders);
    }

    private void qualifiedCertificatesOnly() {
        ApprovedCertificateType approvedCertificate = this.settingsObjectFactory.createApprovedCertificateType();
        approvedCertificate.setAnyQualifiedCertificate(null);
        SigningType signing = this.settingsObjectFactory.createSigningType();
        signing.setSigningCertificate(approvedCertificate);
        this.settings.setSigning(signing);
    }

    private void chooseAlgorithms() {
        AlgorithmsType algorithms = this.settingsObjectFactory.createAlgorithmsType();
        algorithms.setCanonicalizationAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        algorithms.setDigestAlgorithm("SHA256");
        this.settings.setAlgorithms(algorithms);
    }

    static {
        JAXBContext _jaxbContext;
        log = LoggerFactory.getLogger(Settings.class);
        try {
            _jaxbContext = JAXBContext.newInstance(ObjectFactory.class);
        }
        catch (JAXBException e2) {
            throw new IllegalStateException("Tworzenie kontekstu JAXB dla Settings.");
        }
        jaxbContext = _jaxbContext;
    }
}

