/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;

public class CryptoUtils {
    public static final String ENCRYPTION_CERTIFICATE_RESOURCE = "/GIIF.crt";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readCertificate(File f2) {
        try (FileInputStream is = new FileInputStream(f2);){
            X509Certificate x509Certificate = CryptoUtils.readCertificate(is);
            return x509Certificate;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot open encryption certificate file " + f2, ex);
        }
    }

    public static X509Certificate readCertificate(InputStream is) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(is);
        }
        catch (CertificateException e2) {
            throw new IllegalStateException("Cannot read encryption certificate.", e2);
        }
    }

    public static X509Certificate getDefaultEncryptionCertificate() {
        return CryptoUtils.readCertificate(FileSystemUtils.getOverridableResourceInputStream(CryptoUtils.class, ENCRYPTION_CERTIFICATE_RESOURCE));
    }
}

