/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.cli;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import pl.gov.mofnet.giif.signencrypt.cli.ParametersMain;
import pl.gov.mofnet.giif.signencrypt.cli.ParametersSignCommand;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapper;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoWrapperFactory;
import pl.gov.mofnet.giif.signencrypt.crypto.FilePair;

public class SignCommand {
    private ParametersMain parametersMain;
    private ParametersSignCommand parametersSignCommand;
    private CryptoWrapper cryptoWrapper;

    public SignCommand(ParametersMain parametersMain, ParametersSignCommand parametersSignCommand) {
        this.parametersMain = parametersMain;
        this.parametersSignCommand = parametersSignCommand;
        this.cryptoWrapper = CryptoWrapperFactory.getCryptoWraper();
    }

    public int perform() {
        List<FilePair> filesToProcess = this.parametersSignCommand.getFilesToProcess().stream().map(f2 -> this.cryptoWrapper.createFilePair((File)f2, this.parametersSignCommand.getOutputFileName((File)f2))).collect(Collectors.toList());
        this.cryptoWrapper.signEncrypt(filesToProcess, this.parametersSignCommand.getEncryptionCertificates());
        return -1;
    }
}

