/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mofnet.giif.signencrypt.FileSystemUtils;
import pl.gov.mofnet.giif.signencrypt.crypto.CryptoUtils;

@Parameters(commandDescription="Sign and encrypt files.")
public class ParametersSignCommand {
    private static final Logger log = LoggerFactory.getLogger(ParametersSignCommand.class);
    @Parameter(required=true, description="Files to sign and encrypt.")
    List<File> filesToProcess = new ArrayList<File>();
    @Parameter(names={"--suffix"}, description="Suffix to add to encrypted file.")
    String suffix = ".enc";
    @Parameter(names={"--outputFolder", "-o"}, description="Folder to move encrypted file to.")
    File outputFolder;
    @Parameter(names={"--force", "-f"}, description="Overwrite encrypted file.")
    boolean force = false;
    @Parameter(names={"--recipient", "-c"}, description="Encryption certificate in PEM or DER format.")
    List<File> encryptionCertificates;

    public boolean isOverwriteAllowed() {
        return this.force;
    }

    public List<File> getFilesToProcess() {
        return Collections.unmodifiableList(this.filesToProcess);
    }

    public File getOutputFileName(File inputFile) {
        String basename = FileSystemUtils.getBaseName(inputFile);
        String outputFileName = basename + this.suffix;
        if (this.outputFolder == null) {
            log.trace("Output folder not defined, output will be saved to input file's folder.");
            return new File(FileSystemUtils.getParentDirectory(inputFile), outputFileName);
        }
        return new File(this.outputFolder, outputFileName);
    }

    public List<X509Certificate> getEncryptionCertificates() {
        if (this.encryptionCertificates != null && !this.encryptionCertificates.isEmpty()) {
            return this.encryptionCertificates.stream().map(CryptoUtils::readCertificate).collect(Collectors.toList());
        }
        return Collections.singletonList(CryptoUtils.getDefaultEncryptionCertificate());
    }
}

