/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt;

import com.beust.jcommander.JCommander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mofnet.giif.signencrypt.cli.ParametersMain;
import pl.gov.mofnet.giif.signencrypt.cli.ParametersSignCommand;
import pl.gov.mofnet.giif.signencrypt.cli.SignCommand;
import pl.gov.mofnet.giif.signencrypt.gui.GUI;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String SIGN_ENCRYPT_COMMAND_NAME = "signEncrypt";

    public static void main(String[] args) {
        ParametersMain parametersMain = new ParametersMain();
        ParametersSignCommand parametersSignCommand = new ParametersSignCommand();
        JCommander jc = JCommander.newBuilder().addObject(parametersMain).addCommand(SIGN_ENCRYPT_COMMAND_NAME, parametersSignCommand, new String[0]).build();
        jc.parse(args);
        if (parametersMain.isHelp()) {
            jc.usage();
        } else if (jc.getParsedCommand() == null) {
            log.debug("No parameters, launching GUI.");
            GUI.startGui();
        } else {
            switch (jc.getParsedCommand()) {
                case "signEncrypt": {
                    SignCommand command = new SignCommand(parametersMain, parametersSignCommand);
                    System.exit(command.perform());
                }
            }
        }
    }
}

