/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mofnet.giif.signencrypt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final Logger log = LoggerFactory.getLogger(FileSystemUtils.class);

    public static String getBaseName(File inputFile) {
        boolean suffixFound;
        String inputFileName = inputFile.getName();
        int indexOfLastDot = inputFileName.lastIndexOf(46);
        boolean bl2 = suffixFound = indexOfLastDot > 0;
        if (suffixFound) {
            return inputFileName.substring(0, indexOfLastDot);
        }
        return inputFileName;
    }

    public static String getExtension(File inputFile) {
        boolean suffixFound;
        String inputFileName = inputFile.getName();
        int indexOfLastDot = inputFileName.lastIndexOf(46);
        boolean bl2 = suffixFound = indexOfLastDot > 0;
        if (suffixFound) {
            return inputFileName.substring(indexOfLastDot);
        }
        return null;
    }

    public static File getParentDirectory(File location) {
        while (location != null && !location.isDirectory()) {
            location = location.getParentFile();
        }
        return location;
    }

    public static File getJarFolder(Class forClass) {
        try {
            CodeSource codeSource = forClass.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URI locationURI = codeSource.getLocation().toURI();
            if ("file".equals(locationURI.getScheme())) {
                File location = new File(locationURI);
                return FileSystemUtils.getParentDirectory(location);
            }
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static void verifyIfReadable(String fileUse, File file) {
        if (!file.exists()) {
            log.error("{} file {} does not exist.", (Object)fileUse, (Object)file);
            throw new IllegalArgumentException(fileUse + " file " + file + " does not exist.");
        }
        if (!file.canRead()) {
            log.error("{} file {} is not readable.", (Object)fileUse, (Object)file);
            throw new IllegalArgumentException(fileUse + " file " + file + " is not readable.");
        }
    }

    public static String readOverrideableResourceToString(Class forClass, String resource) throws IOException {
        File jarFolder = FileSystemUtils.getJarFolder(forClass);
        File file = new File(jarFolder, resource);
        if (file.canRead()) {
            log.debug("Reading overrideable resource from file: {}", (Object)file);
            return FileSystemUtils.readFileToString(file);
        }
        log.debug("Cannot read overridable resource from file: {}, fallback to resource bundled in jar.", (Object)file);
        return FileSystemUtils.readResourceToString(forClass, resource);
    }

    public static byte[] readOverrideableResourceToBytes(Class forClass, String resource) throws IOException {
        File jarFolder = FileSystemUtils.getJarFolder(forClass);
        File file = new File(jarFolder, resource);
        if (file.canRead()) {
            log.debug("Reading overrideable resource from file: {}", (Object)file);
            return FileSystemUtils.readFileToBytes(file);
        }
        log.debug("Cannot read overridable resource from file: {}, fallback to resource bundled in jar.", (Object)file);
        return FileSystemUtils.readResourceToBytes(forClass, resource);
    }

    public static InputStream getOverridableResourceInputStream(Class forClass, String resource) {
        File jarFolder = FileSystemUtils.getJarFolder(forClass);
        File file = new File(jarFolder, resource);
        if (file.canRead()) {
            log.debug("Reading overrideable resource from file: {}", (Object)file);
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException("Error opening file " + file, ex);
            }
        }
        log.debug("Cannot read overridable resource from file: {}, fallback to resource bundled in jar.", (Object)file);
        return forClass.getResourceAsStream(resource);
    }

    public static String readResourceToString(Class forClass, String resource) throws IOException {
        try (InputStream inputStream = forClass.getResourceAsStream(resource);){
            if (inputStream == null) {
                String string = null;
                return string;
            }
            String string = FileSystemUtils.readInputStreamToString(inputStream);
            return string;
        }
    }

    public static String readFileToString(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = FileSystemUtils.readInputStreamToString(is);
            return string;
        }
    }

    public static byte[] readFileToBytes(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = FileSystemUtils.readInputStreamToBytes(is);
            return byArray;
        }
    }

    private static ByteArrayOutputStream readInputStreamToByteArrayOutputStream(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream collectorStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            collectorStream.write(buffer, 0, bytesRead);
        }
        return collectorStream;
    }

    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream collectorStream = FileSystemUtils.readInputStreamToByteArrayOutputStream(inputStream);){
            String string = collectorStream.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public static byte[] readInputStreamToBytes(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream collectorStream = FileSystemUtils.readInputStreamToByteArrayOutputStream(inputStream);){
            byte[] byArray = collectorStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] readResourceToBytes(Class forClass, String resource) throws IOException {
        try (InputStream inputStream = forClass.getResourceAsStream(resource);){
            byte[] byArray = FileSystemUtils.readInputStreamToBytes(inputStream);
            return byArray;
        }
    }

    public static long copy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        long totalBytesWritten = 0L;
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
            totalBytesWritten += (long)bytesRead;
        }
        return bytesRead;
    }
}

