/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.xml.FormatWriter;

public class XMLFormatter {
    private FormatWriter writer = null;

    public static SAXParserFactory getSAXParserFactoryInstance() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        XMLFormatter.preventXXEinSAXParserFactory(spf);
        return spf;
    }

    public static void preventXXEinSAXParserFactory(SAXParserFactory spf) throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
    }

    public XMLFormatter() {
    }

    public XMLFormatter(FormatWriter writer) {
        this.writer = writer;
    }

    public FormatWriter getWriter() {
        return this.writer;
    }

    public void setWriter(FormatWriter writer) {
        this.writer = writer;
    }

    public String format(String xml) {
        String result = null;
        if (this.writer == null) {
            throw new IllegalArgumentException("Writer is NULL");
        }
        boolean isHeader = true;
        String charsetName = null;
        do {
            try {
                XMLFormatWritter formatWritter = new XMLFormatWritter(this.writer);
                if (xml.indexOf("<?xml") >= 0) {
                    try {
                        String header = xml.substring(xml.indexOf("<?xml"), xml.indexOf("?>") + 2);
                        this.writer.setXMLHeader(header);
                        try {
                            int x2 = header.indexOf("encoding=");
                            if (x2 > 0 && (x2 = header.indexOf("\"", x2)) > 0) {
                                int y2 = header.indexOf("\"", ++x2);
                                charsetName = header.substring(x2, y2);
                            }
                        }
                        catch (Exception ex) {
                            charsetName = null;
                        }
                    }
                    catch (Exception ex) {
                        this.writer.setXMLHeader(null);
                    }
                } else {
                    isHeader = false;
                    if (charsetName != null) {
                        xml = "<?xml version='1.0' encoding='" + charsetName + "'?>" + xml;
                    }
                }
                SAXParser parser = XMLFormatter.getSAXParserFactoryInstance().newSAXParser();
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", formatWritter);
                parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes(charsetName)), (DefaultHandler)formatWritter);
                result = this.writer.toString();
            }
            catch (SAXException ex) {
                if (!isHeader && charsetName == null) {
                    charsetName = "Cp1250";
                    continue;
                }
                throw new IllegalArgumentException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException();
            }
        } while (result == null);
        return result;
    }

    private class XMLFormatWritter
    extends DefaultHandler
    implements LexicalHandler {
        private FormatWriter writer = null;

        public XMLFormatWritter(FormatWriter writer) {
            ParameterValidator.assertNotNull("writer", writer);
            this.writer = writer;
        }

        @Override
        public void startDocument() throws SAXException {
            this.writer.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.writer.endDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            this.writer.startElement(uri, localName, qName, attrs);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.writer.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.writer.characters(ch, start, length);
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.writer.comment(ch, start, length);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public String toString() {
            return this.writer.toString();
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }
    }
}

