/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.xml;

import pl.com.kir.util.StringUtil;

public class XMLBuilder {
    private static final String END_LINE = "\r\n";
    private static final String[][] SPECIAL_CHARACTERS = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&#39;"}};
    private StringBuffer buffer = new StringBuffer();

    public static String encodeXML(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        String result = text;
        for (int i2 = 0; i2 < SPECIAL_CHARACTERS.length; ++i2) {
            result = StringUtil.replace(result, SPECIAL_CHARACTERS[i2][0], SPECIAL_CHARACTERS[i2][1]);
        }
        return result;
    }

    public static String decodeXML(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        String result = text;
        for (int i2 = 0; i2 < SPECIAL_CHARACTERS.length; ++i2) {
            result = StringUtil.replace(result, SPECIAL_CHARACTERS[i2][1], SPECIAL_CHARACTERS[i2][0]);
        }
        return result;
    }

    public void addString(String value) {
        if (value != null) {
            this.addString(value, false);
        }
    }

    public void addString(String value, boolean endLine) {
        this.buffer.append(XMLBuilder.encodeXML(value));
        if (endLine) {
            this.endLine();
        }
    }

    public void addXMLString(String value) {
        if (value != null) {
            this.addXMLString(value, false);
        }
    }

    public void addXMLString(String value, boolean endLine) {
        this.buffer.append(value);
        if (endLine) {
            this.endLine();
        }
    }

    public void endLine() {
        this.buffer.append(END_LINE);
    }

    public void startOpenTag(String name) {
        this.buffer.append("<");
        this.buffer.append(name);
    }

    public void endOpenTag() {
        this.endOpenTag(false);
    }

    public void endOpenTag(boolean endLine) {
        this.buffer.append(">");
        if (endLine) {
            this.endLine();
        }
    }

    public void closeOpenTag() {
        this.closeOpenTag(false);
    }

    public void closeOpenTag(boolean endLine) {
        this.buffer.append("/>");
        if (endLine) {
            this.endLine();
        }
    }

    public void openTag(String name) {
        this.openTag(name, false);
    }

    public void openTag(String name, boolean endLine) {
        this.startOpenTag(name);
        this.endOpenTag();
        if (endLine) {
            this.endLine();
        }
    }

    public void closeTag(String name) {
        this.closeTag(name, false);
    }

    public void closeTag(String name, boolean endLine) {
        this.buffer.append("</");
        this.buffer.append(name);
        this.buffer.append(">");
        if (endLine) {
            this.endLine();
        }
    }

    public void addTag(String name, String value) {
        this.addTag(name, value, false);
    }

    public void addTag(String name, String value, boolean endLine) {
        if (name != null) {
            this.openTag(name);
            if (value != null) {
                this.buffer.append(value);
            }
            this.closeTag(name);
            if (endLine) {
                this.endLine();
            }
        }
    }

    public void addAttribute(String name, String value) {
        if (name != null && value != null) {
            this.addXMLString(" ");
            this.addXMLString(name);
            this.addXMLString("=\"");
            this.addXMLString(value);
            this.addXMLString("\"");
        }
    }

    public void addAttribute(String name, int value) {
        if (name != null) {
            this.addXMLString(" ");
            this.addXMLString(name);
            this.addXMLString("=\"");
            this.addXMLString(Integer.toString(value));
            this.addXMLString("\"");
        }
    }

    public void openXML(String version, String encoding) {
        this.openXML(version, encoding, false);
    }

    public void openXML(String version, String encoding, boolean endLine) {
        this.buffer.append("<?xml version='");
        this.buffer.append(version);
        this.buffer.append("' encoding='");
        this.buffer.append(encoding);
        this.buffer.append("'?>");
        if (endLine) {
            this.endLine();
        }
    }

    public int length() {
        return this.buffer.length();
    }

    public void clear() {
        this.buffer = new StringBuffer();
    }

    public String toXMLString() {
        return this.buffer.toString();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }
}

