/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.xml;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.xml.FormatWriter;

public class TextFormatWriter
implements FormatWriter {
    private static final int NONE = -1;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private static final int CHARACTER_SHORT = 2;
    private static final int CHARACTER_LONG = 3;
    private static int TAB = 4;
    private StringBuffer buffer = new StringBuffer();
    private String header = null;
    private int lastElement = -1;
    private String lastQName = null;
    private int lastCharacterLength = 0;
    private int tab = 0;

    @Override
    public void setXMLHeader(String header) {
        if (header != null) {
            header = header.trim();
        }
        this.header = header;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.header != null) {
            this.buffer.append(this.header);
            this.buffer.append("\r\n");
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.lastElement == 0) {
            this.buffer.append(">");
            this.tab += TAB;
        }
        if (this.lastElement != -1) {
            this.buffer.append("\r\n");
        }
        this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
        this.buffer.append("<");
        this.buffer.append(qName);
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            String attrQName = attrs.getQName(i2);
            String attrValue = attrs.getValue(i2);
            this.buffer.append(" ");
            this.buffer.append(attrQName);
            this.buffer.append("=\"");
            this.buffer.append(attrValue);
            this.buffer.append("\"");
        }
        this.lastElement = 0;
        this.lastQName = qName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.lastElement == 0) {
            if (qName.equals(this.lastQName)) {
                this.buffer.append("/>");
            } else {
                this.buffer.append(">");
            }
        } else if (this.lastElement == 3) {
            this.buffer.append("\r\n");
        }
        if (this.lastElement != 0 || !qName.equals(this.lastQName)) {
            if (this.lastElement == 1) {
                this.buffer.append("\r\n");
                this.tab -= TAB;
                this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
            } else if (this.lastElement == 3) {
                this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
            }
            this.buffer.append("</");
            this.buffer.append(qName);
            this.buffer.append(">");
        }
        this.lastElement = 1;
        this.lastQName = qName;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if ((value = value.trim()).length() > 0) {
            if (this.lastElement == 0) {
                this.buffer.append(">");
            }
            if (this.lastElement != 3 && value.length() <= 80) {
                this.buffer.append(value);
                this.lastElement = 2;
            } else {
                this.tab += TAB;
                int count = this.lastElement == 3 ? this.lastCharacterLength : 0;
                for (int i2 = 0; i2 < value.length(); ++i2) {
                    char c2 = value.charAt(i2);
                    if (c2 < ' ') continue;
                    if (count % 80 == 0 && (this.lastElement != 3 || count > 0)) {
                        this.buffer.append("\r\n");
                        this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
                    }
                    this.buffer.append(c2);
                    ++count;
                }
                this.tab -= TAB;
                this.lastElement = 3;
                this.lastCharacterLength = count;
            }
        }
        this.lastQName = null;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String comment = new String(ch, start, length);
        if ((comment = comment.trim()).length() > 0) {
            if (this.lastElement == 0) {
                this.buffer.append(">");
                this.tab += TAB;
            }
            this.buffer.append("\r\n");
            this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
            this.buffer.append("<!--");
            String[] token = StringUtil.toTokenArray(comment, "\n");
            if (token.length == 1) {
                this.buffer.append(" ");
                this.buffer.append(comment);
                this.buffer.append(" ");
            } else {
                for (int i2 = 0; i2 < token.length; ++i2) {
                    this.buffer.append("\r\n");
                    this.buffer.append(StringUtil.fillRight("", this.tab + TAB, ' '));
                    this.buffer.append(token[i2].trim());
                }
                this.buffer.append("\r\n");
                this.buffer.append(StringUtil.fillRight("", this.tab, ' '));
            }
            this.buffer.append("-->");
            this.lastElement = 1;
            this.lastQName = "_comment_";
        }
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

