/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.xml;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.html.HTMLBuilder;
import pl.com.kir.util.html.HTMLFontAttributes;
import pl.com.kir.util.html.HTMLTextAttributes;
import pl.com.kir.util.xml.FormatWriter;

public class HTMLFormatWriter
implements FormatWriter {
    private static final int NONE = -1;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private static final int CHARACTER_SHORT = 2;
    private static final int CHARACTER_LONG = 3;
    private static final HTMLTextAttributes TEXT_BLUE = new HTMLTextAttributes("blue");
    private static final HTMLTextAttributes TEXT_BROWN = new HTMLTextAttributes("#A52A2A");
    private static final HTMLTextAttributes TEXT_GRAY = new HTMLTextAttributes("gray");
    private static final HTMLTextAttributes TEXT_BLACK = new HTMLTextAttributes("black", true, false);
    private static int TAB = 4;
    private HTMLBuilder builder = new HTMLBuilder();
    private String header = null;
    private int lastElement = -1;
    private String lastQName = null;
    private int lastCharacterLength = 0;
    private int tab = 0;

    @Override
    public void setXMLHeader(String header) {
        this.header = header;
    }

    @Override
    public void startDocument() throws SAXException {
        this.builder.addHTML("<tt>");
        if (this.header != null) {
            this.builder.addText(this.header, TEXT_BLUE);
            this.builder.addBR();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.builder.addHTML("</tt>");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.lastElement == 0) {
            this.builder.addText(">", TEXT_BLUE);
            this.tab += TAB;
        }
        if (this.lastElement != -1) {
            this.builder.addBR();
        }
        this.addTab(this.tab);
        this.builder.addText("<", TEXT_BLUE);
        this.builder.addText(qName, TEXT_BROWN);
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            String attrQName = attrs.getQName(i2);
            String attrValue = attrs.getValue(i2);
            this.builder.addText(" ");
            this.builder.addText(attrQName, TEXT_BROWN);
            this.builder.addText("=\"", TEXT_BLUE);
            this.builder.addText(attrValue, TEXT_BLACK);
            this.builder.addText("\"", TEXT_BLUE);
        }
        this.lastElement = 0;
        this.lastQName = qName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.lastElement == 0) {
            if (qName.equals(this.lastQName)) {
                this.builder.addText("/>", TEXT_BLUE);
            } else {
                this.builder.addText(">", TEXT_BLUE);
            }
        } else if (this.lastElement == 3) {
            this.builder.addBR();
        }
        if (this.lastElement != 0 || !qName.equals(this.lastQName)) {
            if (this.lastElement == 1) {
                this.builder.addBR();
                this.tab -= TAB;
                this.addTab(this.tab);
            } else if (this.lastElement == 3) {
                this.addTab(this.tab);
            }
            this.builder.addText("</", TEXT_BLUE);
            this.builder.addText(qName, TEXT_BROWN);
            this.builder.addText(">", TEXT_BLUE);
        }
        this.lastElement = 1;
        this.lastQName = qName;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if ((value = value.trim()).length() > 0) {
            if (this.lastElement == 0) {
                this.builder.addText(">", TEXT_BLUE);
            }
            this.builder.openFONT(new HTMLFontAttributes("black"));
            this.builder.openBold();
            if (this.lastElement != 3 && value.length() <= 80) {
                this.builder.addText(value);
                this.lastElement = 2;
            } else {
                this.tab += TAB;
                int count = this.lastElement == 3 ? this.lastCharacterLength : 0;
                for (int i2 = 0; i2 < value.length(); ++i2) {
                    char c2 = value.charAt(i2);
                    if (c2 < ' ') continue;
                    if (count % 80 == 0 && (this.lastElement != 3 || count > 0)) {
                        this.builder.addBR();
                        this.addTab(this.tab);
                    }
                    this.builder.addText(Character.toString(c2));
                    ++count;
                }
                this.tab -= TAB;
                this.lastElement = 3;
                this.lastCharacterLength = count;
            }
            this.builder.closeBold();
            this.builder.closeFONT();
        }
        this.lastQName = null;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String comment = new String(ch, start, length);
        if ((comment = comment.trim()).length() > 0) {
            if (this.lastElement == 0) {
                this.builder.addText(">", TEXT_BLUE);
                this.tab += TAB;
            }
            this.builder.addBR();
            this.addTab(this.tab);
            this.builder.addText("<!--", TEXT_BLUE);
            String[] token = StringUtil.toTokenArray(comment, "\n");
            if (token.length == 1) {
                this.builder.addText(" " + comment + " ", TEXT_GRAY);
            } else {
                for (int i2 = 0; i2 < token.length; ++i2) {
                    this.builder.addBR();
                    this.addTab(this.tab + TAB);
                    this.builder.addText(token[i2].trim(), TEXT_GRAY);
                }
                this.builder.addBR();
                this.addTab(this.tab);
            }
            this.builder.addText("-->", TEXT_BLUE);
            this.lastElement = 1;
            this.lastQName = "_comment_";
        }
    }

    @Override
    public String toString() {
        return this.builder.toHTMLString();
    }

    private void addTab(int tab) {
        this.builder.addNBSP(tab);
    }
}

