/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.xml;

public abstract class AbstractXMLBuilder {
    private static final String END_LINE = "\r\n";
    private StringBuffer buffer = new StringBuffer();

    public void addXMLString(String value) {
        this.addXMLString(value, false);
    }

    public void addXMLString(String value, boolean endLine) {
        if (value != null) {
            this.buffer.append(value);
            this.endLine(endLine);
        }
    }

    protected void endLine() {
        this.endLine(true);
    }

    private void endLine(boolean endLine) {
        if (endLine) {
            this.buffer.append(END_LINE);
        }
    }

    protected void startOpenTag(String name) {
        this.buffer.append("<");
        this.buffer.append(name);
    }

    protected void endOpenTag() {
        this.endOpenTag(false);
    }

    protected void endOpenTag(boolean endLine) {
        this.buffer.append(">");
        this.endLine(endLine);
    }

    protected void closeOpenTag() {
        this.closeOpenTag(false);
    }

    protected void closeOpenTag(boolean endLine) {
        this.buffer.append("/>");
        this.endLine(endLine);
    }

    protected void openTag(String name) {
        this.openTag(name, false);
    }

    protected void openTag(String name, boolean endLine) {
        this.startOpenTag(name);
        this.endOpenTag();
        this.endLine(endLine);
    }

    protected void closeTag(String name) {
        this.closeTag(name, false);
    }

    protected void closeTag(String name, boolean endLine) {
        this.buffer.append("</");
        this.buffer.append(name);
        this.buffer.append(">");
        this.endLine(endLine);
    }

    protected void addTag(String name, String value) {
        this.addTag(name, value, false);
    }

    protected void addTag(String name, String value, boolean endLine) {
        if (name != null && value != null) {
            this.openTag(name);
            this.buffer.append(value);
            this.closeTag(name);
            this.endLine(endLine);
        }
    }

    protected void addAttribute(String name, String value) {
        if (name != null && value != null) {
            this.addXMLString(" ");
            this.addXMLString(name);
            this.addXMLString("=\"");
            this.addXMLString(value);
            this.addXMLString("\"");
        }
    }

    protected void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    public void openXML(String version, String encoding) {
        this.openXML(version, encoding, false);
    }

    public void openXML(String version, String encoding, boolean endLine) {
        this.buffer.append("<?xml");
        if (version != null) {
            this.buffer.append(" version='");
            this.buffer.append(version);
            this.buffer.append("'");
        }
        if (encoding != null) {
            this.buffer.append(" encoding='");
            this.buffer.append(encoding);
            this.buffer.append("'");
        }
        this.buffer.append("?>");
        this.endLine(endLine);
    }

    public void clear() {
        this.buffer = new StringBuffer();
    }

    public int length() {
        return this.buffer.length();
    }

    public String toXMLString() {
        return this.buffer.toString();
    }
}

