/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.validator;

import pl.com.kir.util.StringUtil;

public class VATIDValidator {
    private static final String[] REGEXP_MAP = new String[]{"ATU\\S{8}", "BE\\d{10}", "BG\\d{9}", "BG\\d{10}", "CY\\S{9}", "CZ\\d{8}", "CZ\\d{9}", "CZ\\d{10}", "DE\\d{9}", "DK\\d{2} \\d{2} \\d{2} \\d{2}", "EE\\d{9}", "EL\\d{9}", "ES\\S{9}", "FI\\d{8}", "FR\\S{2} \\d{9}", "GB\\d{3} \\d{4} \\d{2}", "GB\\d{3} \\d{4} \\d{2} \\d{3}", "GB\\S{5}", "HU\\d{8}", "IE\\S{8}", "IT\\d{11}", "LT\\d{9}", "LT\\d{12}", "LU\\d{8}", "LV\\d{11}", "MT\\d{8}", "NL\\S{9}B\\S{2}", "PL\\d{10}", "PT\\d{9}", "RO\\d{2,10}", "SE\\d{12}", "SI\\d{8}", "SK\\d{10}"};

    public static boolean isCorrect(String value) {
        boolean result = false;
        if (StringUtil.isEmpty(value)) {
            result = false;
        } else {
            for (int i2 = 0; !result && i2 < REGEXP_MAP.length; ++i2) {
                String regexp = REGEXP_MAP[i2];
                if (!value.matches(regexp)) continue;
                result = true;
            }
        }
        return result;
    }
}

