/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.validator;

import pl.com.kir.util.ChecksumNumbersHelper;
import pl.com.kir.util.StringUtil;

public class REGONValidator {
    private static final String[] REGEXP_MAP = new String[]{"\\d{9}", "\\d{14}"};
    public static final String W_REGON_9 = "89234567";
    public static final String W_REGON_14 = "2485097361248";

    private REGONValidator() {
    }

    public static boolean isCorrect(String value) {
        boolean result = false;
        if (StringUtil.isEmpty(value) || value.length() != 9 && value.length() != 14) {
            result = false;
        } else {
            for (int i2 = 0; !result && i2 < REGEXP_MAP.length; ++i2) {
                String regexp = REGEXP_MAP[i2];
                if (!value.matches(regexp)) continue;
                result = true;
            }
            if (result) {
                try {
                    Long.parseLong(value);
                    String wagi = value.length() == 9 ? W_REGON_9 : W_REGON_14;
                    int q2 = REGONValidator.checksum(value, wagi);
                    int crc = Integer.parseInt(value.substring(value.length() - 1, value.length()));
                    return crc == q2;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return result;
    }

    public static int checksum(String numer, String wagi) {
        int result = ChecksumNumbersHelper.checksum(numer, wagi) % 11;
        if (result >= 10) {
            result -= 10;
        }
        return result;
    }
}

