/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.validator;

import pl.com.kir.util.ChecksumNumbersHelper;
import pl.com.kir.util.StringUtil;

public class PESELValidator {
    private static final String[] REGEXP_MAP = new String[]{"\\d{11}"};
    public static final String W_PESEL = "1379137913";

    private PESELValidator() {
    }

    public static boolean isCorrect(String value) {
        boolean result = false;
        if (StringUtil.isEmpty(value) || value.length() != 11) {
            result = false;
        } else {
            for (int i2 = 0; !result && i2 < REGEXP_MAP.length; ++i2) {
                String regexp = REGEXP_MAP[i2];
                if (!value.matches(regexp)) continue;
                result = true;
            }
            if (result) {
                try {
                    int crc;
                    Long.parseLong(value);
                    int q2 = 10 - PESELValidator.checksum(value);
                    if (q2 == 10) {
                        q2 = 0;
                    }
                    return (crc = Integer.parseInt(value.substring(10, 11))) == q2;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return result;
    }

    public static int checksum(String numer) {
        return ChecksumNumbersHelper.checksum(numer, W_PESEL) % 10;
    }
}

