/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.validator;

import pl.com.kir.util.ChecksumNumbersHelper;
import pl.com.kir.util.StringUtil;

public class NIPValidator {
    private static final String[] REGEXP_MAP = new String[]{"PL\\d{10}", "\\d{10}", "\\d{3}-\\d{3}-\\d{2}-\\d{2}", "\\d{3}-\\d{2}-\\d{2}-\\d{3}"};
    public static final String W_NIP = "657234567";

    private NIPValidator() {
    }

    public static boolean isCorrect(String value) {
        boolean result = false;
        if (StringUtil.isEmpty(value) || value.length() != 13 && value.length() != 10 && value.length() != 12) {
            result = false;
        } else {
            for (int i2 = 0; !result && i2 < REGEXP_MAP.length; ++i2) {
                String regexp = REGEXP_MAP[i2];
                if (!value.matches(regexp)) continue;
                result = true;
            }
            if (result) {
                if ((value = value.replace("-", "")).startsWith("PL")) {
                    value = value.substring(2);
                }
                try {
                    Long.parseLong(value);
                    int q2 = NIPValidator.checksum(value);
                    int crc = Integer.parseInt(value.substring(9, 10));
                    return crc == q2;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return result;
    }

    public static int checksum(String numer) {
        int result = ChecksumNumbersHelper.checksum(numer, W_NIP) % 11;
        if (result >= 10) {
            result -= 10;
        }
        return result;
    }
}

