/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import pl.com.kir.util.DateTimeHelper;
import pl.com.kir.util.StandardResourceManager;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.swing.dialog.AbstractDialog;
import pl.com.kir.util.swing.dialog.DialogResourceManager;

public class DateTimeDialog
extends AbstractDialog {
    public static final int MODE_DATE_TIME = 0;
    public static final int MODE_DATE = 1;
    public static final int MODE_TIME = 2;
    private static final long serialVersionUID = -5946972288425098838L;
    private static final String[] MONTHS = StandardResourceManager.getMonths();
    protected static Dimension SIZE_4_MODE_DATE_TIME = new Dimension(440, 140);
    protected static Dimension SIZE_4_MODE_DATE = new Dimension(280, 140);
    protected static Dimension SIZE_4_MODE_TIME = new Dimension(260, 140);
    protected int mode = 0;
    protected Date dateTime = null;
    protected JSpinner daySpinner = null;
    protected JSpinner monthSpinner = null;
    protected JSpinner yearSpinner = null;
    protected JSpinner hourSpinner = null;
    protected JSpinner minuteSpinner = null;
    protected JSpinner secondSpinner = null;
    protected JLabel label1 = null;
    protected JLabel label2 = null;
    protected JLabel label3 = null;
    protected JButton acceptButton = null;
    protected JPanel centerPanel = null;
    protected JPanel bottomPanel = null;

    public DateTimeDialog(Frame parent, boolean modal, int mode) {
        this(parent, modal, mode, null);
    }

    public DateTimeDialog(Frame parent, boolean modal, int mode, Date date) {
        super(parent, modal);
        this.mode = mode;
        this.addEscapeAction();
        this.initComponents();
        this.setDateTime(date);
        this.getRootPane().setDefaultButton(this.acceptButton);
        this.acceptButton.requestFocus();
        this.packAndCenterByFrame();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setSize(200, 130);
        JPanel contentPanePanel = new JPanel(new BorderLayout(0, 0));
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(contentPanePanel);
        switch (this.mode) {
            case 0: {
                this.setTitle(DialogResourceManager.getString(DateTimeDialog.class, "dateTime.title"));
                this.setSize(SIZE_4_MODE_DATE_TIME);
                this.setPreferredSize(SIZE_4_MODE_DATE_TIME);
                break;
            }
            case 1: {
                this.setTitle(DialogResourceManager.getString(DateTimeDialog.class, "date.title"));
                this.setSize(SIZE_4_MODE_DATE);
                this.setPreferredSize(SIZE_4_MODE_DATE);
                break;
            }
            case 2: {
                this.setTitle(DialogResourceManager.getString(DateTimeDialog.class, "time.title"));
                this.setSize(SIZE_4_MODE_TIME);
                this.setPreferredSize(SIZE_4_MODE_TIME);
            }
        }
        this.setResizable(false);
        Dimension d40x20 = new Dimension(40, 20);
        this.centerPanel = new JPanel(new FlowLayout(1, 4, 8));
        this.centerPanel.setPreferredSize(new Dimension(1, 40));
        this.centerPanel.setBorder(BorderFactory.createTitledBorder(""));
        if (this.mode == 0 || this.mode == 1) {
            this.daySpinner = new JSpinner();
            this.daySpinner.setPreferredSize(d40x20);
            this.centerPanel.add(this.daySpinner);
            this.monthSpinner = new JSpinner();
            this.monthSpinner.setPreferredSize(new Dimension(90, 20));
            this.monthSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    DateTimeDialog.this.updateDaySpinner(evt);
                }
            });
            this.centerPanel.add(this.monthSpinner);
            this.yearSpinner = new JSpinner();
            this.yearSpinner.setPreferredSize(new Dimension(52, 20));
            this.yearSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    DateTimeDialog.this.updateDaySpinner(evt);
                }
            });
            this.centerPanel.add(this.yearSpinner);
        }
        if (this.mode == 0) {
            this.label1 = new JLabel("    ");
            this.centerPanel.add(this.label1);
        }
        if (this.mode == 0 || this.mode == 2) {
            this.hourSpinner = new JSpinner();
            this.hourSpinner.setPreferredSize(d40x20);
            this.centerPanel.add(this.hourSpinner);
            this.label2 = new JLabel(" : ");
            this.centerPanel.add(this.label2);
            this.minuteSpinner = new JSpinner();
            this.minuteSpinner.setPreferredSize(d40x20);
            this.centerPanel.add(this.minuteSpinner);
            this.label3 = new JLabel(" : ");
            this.centerPanel.add(this.label3);
            this.secondSpinner = new JSpinner();
            this.secondSpinner.setPreferredSize(d40x20);
            this.centerPanel.add(this.secondSpinner);
        }
        this.bottomPanel = new JPanel(new FlowLayout(1, 12, 12));
        this.acceptButton = new JButton(DialogResourceManager.getString("button.ok"));
        this.acceptButton.setPreferredSize(new Dimension(75, 23));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateTimeDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.acceptButton);
        JPanel topPanel = new JPanel();
        topPanel.setPreferredSize(new Dimension(1, 16));
        JPanel leftPanel = new JPanel();
        leftPanel.setPreferredSize(new Dimension(16, 1));
        JPanel rightPanel = new JPanel();
        rightPanel.setPreferredSize(new Dimension(16, 1));
        contentPanePanel.add((Component)topPanel, "First");
        contentPanePanel.add((Component)leftPanel, "Before");
        contentPanePanel.add((Component)this.centerPanel, "Center");
        contentPanePanel.add((Component)rightPanel, "After");
        contentPanePanel.add((Component)this.bottomPanel, "Last");
    }

    public void setDateTime(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (date != null) {
            calendar.setTime(date);
        }
        if (this.mode == 0 || this.mode == 1) {
            this.daySpinner.setModel(new SpinnerNumberModel(calendar.get(5), 1, ((Calendar)calendar).getActualMaximum(5), 1));
            SpinnerListModel monthModel = new SpinnerListModel(MONTHS);
            monthModel.setValue(MONTHS[calendar.get(2)]);
            this.monthSpinner.setModel(monthModel);
            this.yearSpinner.setModel(new SpinnerNumberModel(calendar.get(1), 1900, 2100, 1));
            DefaultFormatter formatter = new DefaultFormatter();
            JFormattedTextField formattedTextField = ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField();
            formattedTextField.setFormatterFactory(new DefaultFormatterFactory(formatter, formatter, formatter));
        }
        if (this.mode == 0 || this.mode == 2) {
            this.hourSpinner.setModel(new SpinnerNumberModel(calendar.get(11), 0, 23, 1));
            this.minuteSpinner.setModel(new SpinnerNumberModel(calendar.get(12), 0, 59, 1));
            this.secondSpinner.setModel(new SpinnerNumberModel(calendar.get(13), 0, 59, 1));
        }
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    protected void updateDaySpinner(ChangeEvent evt) {
        String monthLabel = (String)this.monthSpinner.getValue();
        int month = StringUtil.search(MONTHS, monthLabel);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, month);
        calendar.set(1, (Integer)this.yearSpinner.getValue());
        int max = ((Calendar)calendar).getActualMaximum(5);
        SpinnerNumberModel dayModel = (SpinnerNumberModel)this.daySpinner.getModel();
        dayModel.setMaximum(new Integer(max));
        if ((Integer)this.daySpinner.getValue() > max) {
            dayModel.setValue(new Integer(max));
        }
        this.daySpinner.setModel(dayModel);
    }

    protected void acceptButtonActionPerformed(ActionEvent evt) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (this.mode == 0 || this.mode == 1) {
            calendar.set(5, (Integer)this.daySpinner.getValue());
            calendar.set(2, StringUtil.search(MONTHS, (String)this.monthSpinner.getValue()));
            calendar.set(1, (Integer)this.yearSpinner.getValue());
        } else {
            calendar.set(5, 1);
            calendar.set(2, 1);
            calendar.set(1, 1);
        }
        if (this.mode == 0 || this.mode == 2) {
            calendar.set(11, (Integer)this.hourSpinner.getValue());
            calendar.set(12, (Integer)this.minuteSpinner.getValue());
            calendar.set(13, (Integer)this.secondSpinner.getValue());
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        calendar.set(14, 0);
        this.dateTime = calendar.getTime();
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DateTimeDialog dialog = new DateTimeDialog(null, true, 0);
                dialog.setVisible(true);
                Date result = dialog.getDateTime();
                if (result != null) {
                    System.out.println(DateTimeHelper.toString(result, "yyyy-MM-dd HH:mm:ss.SSS"));
                } else {
                    System.out.println("Result is NULL");
                }
            }
        });
    }
}

