/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = -3431866507395449605L;

    protected AbstractDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    protected AbstractDialog(Frame parent, boolean modal, String title) {
        this(parent, modal);
        this.setTitle(title);
    }

    protected void addEscapeAction() {
        JRootPane rootPane = this.getRootPane();
        InputMap iMap = rootPane.getInputMap(1);
        iMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap aMap = rootPane.getActionMap();
        aMap.put("escape", new EscapeAction(this));
    }

    public void setLocationByFrame(Frame parent) {
        this.setLocationRelativeTo(parent);
    }

    public void setLocationByScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x2 = (int)((dim.getWidth() - (double)this.getWidth()) / 2.0);
        int y2 = (int)((dim.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x2, y2);
    }

    public void setLocationByOwner() {
        this.setLocationRelativeTo(this.getOwner());
    }

    public void packAndCenterByFrame() {
        this.pack();
        this.setLocationByOwner();
    }

    public void packAndCenterByScreen() {
        this.pack();
        this.setLocationByScreen();
    }

    private class EscapeAction
    extends AbstractAction {
        private static final long serialVersionUID = -7634100579469410929L;
        private JDialog dialog = null;

        public EscapeAction(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
        }
    }
}

