/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.StringUtil;

public class SwingHelper {
    private SwingHelper() {
    }

    public static void setWidth(JTable table, int columnIndex, int width) {
        ParameterValidator.assertNotNull("table", table);
        ParameterValidator.assertUnnegativeNumber("columnIndex", columnIndex);
        ParameterValidator.assertUnnegativeNumber("width", width);
        SwingHelper.setWidth(table.getColumnModel().getColumn(columnIndex), width);
    }

    public static void setWidth(TableColumn column, int width) {
        ParameterValidator.assertNotNull("column", column);
        ParameterValidator.assertUnnegativeNumber("width", width);
        column.setResizable(false);
        column.setWidth(width);
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    public static void setSize(Component component, Dimension dim) {
        ParameterValidator.assertNotNull("component", component);
        ParameterValidator.assertNotNull("dim", dim);
        component.setSize(dim);
        component.setPreferredSize(dim);
        component.setMinimumSize(dim);
        component.setMaximumSize(dim);
    }

    public static void showAllNodes(JTree tree) {
        ParameterValidator.assertNotNull("tree", tree);
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            tree.expandRow(i2);
        }
    }

    public static Color getColor(String htmlColorValue) {
        Color result = null;
        if (htmlColorValue != null && htmlColorValue.length() == 7) {
            String rh = htmlColorValue.substring(1, 3);
            String gh = htmlColorValue.substring(3, 5);
            String bh2 = htmlColorValue.substring(5, 7);
            int r2 = Integer.valueOf(rh, 16);
            int g2 = Integer.valueOf(gh, 16);
            int b2 = Integer.valueOf(bh2, 16);
            result = new Color(r2, g2, b2);
        }
        return result;
    }

    public static String getHTMLColor(Color colorValue) {
        String result = null;
        if (colorValue != null) {
            int r2 = colorValue.getRed();
            int g2 = colorValue.getGreen();
            int b2 = colorValue.getBlue();
            String rh = Integer.toHexString(r2);
            String gh = Integer.toHexString(g2);
            String bh2 = Integer.toHexString(b2);
            result = "#" + StringUtil.fillLeft(rh, 2, '0') + StringUtil.fillLeft(gh, 2, '0') + StringUtil.fillLeft(bh2, 2, '0');
        }
        return result;
    }

    public static void setPolishLanguageToJFileChooser() {
        UIManager.put("FileChooser.lookInLabelText", "Lokalizacja:");
        UIManager.put("FileChooser.saveInLabelText", "Lokalizacja:");
        UIManager.put("FileChooser.fileNameLabelText", "Nazwa pliku");
        UIManager.put("FileChooser.filesOfTypeLabelText", "Pliki typu");
        UIManager.put("FileChooser.openButtonText", "Otw\u00f3rz");
        UIManager.put("FileChooser.saveButtonText", "Zapisz");
        UIManager.put("FileChooser.cancelButtonText", "Anuluj");
        UIManager.put("FileChooser.helpButtonText", "Pomoc");
        UIManager.put("FileChooser.openButtonToolTipText", "Otw\u00f3rz");
        UIManager.put("FileChooser.saveButtonToolTipText", "Zapisz");
        UIManager.put("FileChooser.cancelButtonToolTipText", "Anuluj");
        UIManager.put("FileChooser.helpButtonToolTipText", "Pomoc");
        UIManager.put("FileChooser.upFolderToolTipText", "Jeden poziom do g\u00f3ry");
        UIManager.put("FileChooser.newFolderToolTipText", "Utw\u00f3rz nowy folder");
        UIManager.put("FileChooser.listViewButtonToolTipText", "Lista");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "Szczeg\u00f3\u0142y");
        UIManager.put("FileChooser.openDialogTitleText", "Otw\u00f3rz");
        UIManager.put("FileChooser.saveDialogTitleText", "Zapisz");
        UIManager.put("FileChooser.acceptAllFileFilterText", "Wszystkie pliki");
    }
}

