/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import javax.swing.JFrame;
import pl.com.kir.util.ParameterValidator;

public class SplashScreen
extends JFrame {
    private static final long serialVersionUID = 4186325335650960622L;
    private Image image = null;
    private int interval = 0;
    private MediaTracker fMediaTracker;
    private static final ImageObserver NO_OBSERVER = null;
    private static final int IMAGE_ID = 0;

    public SplashScreen(Image image, int interval) {
        ParameterValidator.assertNotNull("image", image);
        this.image = image;
        this.interval = interval;
    }

    public void splash() {
        this.fMediaTracker = new MediaTracker(this);
        this.setSize(this.image.getWidth(NO_OBSERVER), this.image.getHeight(NO_OBSERVER));
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
        this.fMediaTracker.addImage(this.image, 0);
        try {
            this.fMediaTracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            System.out.println("Cannot track image load.");
        }
        SplashWindow splashWindow = new SplashWindow(this, this.image);
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException ex) {
            System.out.println(ex);
        }
        splashWindow.dispose();
        this.dispose();
    }

    private class SplashWindow
    extends Window {
        private static final long serialVersionUID = 6956468323044736897L;
        private Image fImage;

        SplashWindow(Frame aParent, Image aImage) {
            super(aParent);
            this.fImage = aImage;
            this.setSize(this.fImage.getWidth(NO_OBSERVER), this.fImage.getHeight(NO_OBSERVER));
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle window = this.getBounds();
            this.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.fImage != null) {
                graphics.drawImage(this.fImage, 0, 0, this);
            }
        }
    }
}

