/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.io.File;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import pl.com.kir.util.ParameterValidator;

public class FileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6144742505831801245L;
    private String[] columnNames = null;
    private ArrayList<File> rows = null;

    public FileTableModel(String fileNameLabel, String fileSizeLabel, String fileDateLabel) {
        ParameterValidator.assertNotNull("fileNameLabel", fileNameLabel);
        ParameterValidator.assertNotNull("fileSizeLabel", fileSizeLabel);
        ParameterValidator.assertNotNull("fileDateLabel", fileDateLabel);
        this.columnNames = new String[]{fileNameLabel, fileSizeLabel, fileDateLabel};
        this.rows = new ArrayList();
    }

    public void addFile(File file) {
        if (file != null) {
            this.rows.add(file);
        }
    }

    public void addFiles(File[] files) {
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                this.addFile(files[i2]);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int idx) {
        return this.columnNames[idx];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public Class<?> getColumnClass(int idx) {
        return File.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void clear() {
        this.rows.clear();
    }
}

