/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Component;
import java.io.File;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableCellRenderer;
import pl.com.kir.util.DateTimeHelper;
import pl.com.kir.util.swing.JLabelFactory;

public class FileTableCellRenderer
implements TableCellRenderer {
    private static final Border LABEL_BORDER = BorderFactory.createEmptyBorder(0, 4, 0, 4);
    private FileSystemView fileSystemView = new JFileChooser().getFileSystemView();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof File)) {
            throw new IllegalArgumentException("Argument 'value' is not java.awt.Component");
        }
        File f2 = (File)value;
        JComponent label = null;
        switch (column) {
            case 0: {
                label = JLabelFactory.getLabel(f2.getName(), this.fileSystemView.getSystemIcon(f2), 2, LABEL_BORDER);
                break;
            }
            case 1: {
                String text = Long.toString(f2.length());
                label = JLabelFactory.getLabel(text, 4, LABEL_BORDER);
                break;
            }
            case 2: {
                String text = DateTimeHelper.toString(new Date(f2.lastModified()), "yyyy-MM-dd HH:mm");
                label = JLabelFactory.getLabel(text, 0, LABEL_BORDER);
            }
        }
        if (isSelected) {
            label.setForeground(table.getSelectionForeground());
            label.setBackground(table.getSelectionBackground());
        } else {
            label.setForeground(table.getForeground());
            label.setBackground(table.getBackground());
        }
        return label;
    }
}

