/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileSystemView;

public class FileListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -5361615331955472405L;
    private int count = 0;
    private int hashCodeList = 0;
    private boolean useSystemDisplayName = false;
    private FileSystemView fileSystemView = null;

    public FileListCellRenderer() {
        this(false);
    }

    public FileListCellRenderer(boolean useSystemDisplayName) {
        this.useSystemDisplayName = useSystemDisplayName;
        this.setOpaque(true);
        this.fileSystemView = new JFileChooser().getFileSystemView();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof File)) {
            throw new IllegalArgumentException("Argument 'value' is not java.io.File");
        }
        if (list.getModel().hashCode() != this.hashCodeList) {
            this.count = 0;
            this.hashCodeList = list.getModel().hashCode();
        }
        ++this.count;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        File f2 = (File)value;
        if (this.useSystemDisplayName) {
            String name = f2.getName();
            String displayName = this.fileSystemView.getSystemDisplayName(f2);
            if (name != null && name.length() > 0 && name.startsWith(displayName)) {
                displayName = displayName + name.substring(displayName.length());
            }
            this.setText(displayName);
        } else {
            this.setText(f2.getName());
        }
        try {
            if (this.count > list.getModel().getSize()) {
                this.setIcon(this.fileSystemView.getSystemIcon(f2));
            } else {
                this.setIcon(null);
            }
        }
        catch (Throwable th) {
            this.setIcon(null);
        }
        return this;
    }
}

