/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ComponentTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6314374039310566625L;
    private boolean defaultOpaque = false;
    private boolean reactToSelection = true;

    public ComponentTreeCellRenderer() {
    }

    public ComponentTreeCellRenderer(boolean defaultOpaque) {
        this.defaultOpaque = defaultOpaque;
    }

    public ComponentTreeCellRenderer(boolean defaultOpaque, boolean reactToSelection) {
        this.defaultOpaque = defaultOpaque;
        this.reactToSelection = reactToSelection;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException("Argument 'value' is not javax.swing.tree.DefaultMutableTreeNode");
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        Component component = null;
        component = userObject instanceof Component ? (Component)userObject : new JLabel(userObject.toString());
        if (this.reactToSelection) {
            if (isSelected) {
                component.setForeground(this.getTextSelectionColor());
                component.setBackground(this.getBackgroundSelectionColor());
            } else {
                component.setForeground(this.getTextNonSelectionColor());
                component.setBackground(this.getBackgroundNonSelectionColor());
            }
        }
        if (this.defaultOpaque && component instanceof JComponent) {
            ((JComponent)component).setOpaque(true);
        }
        return component;
    }
}

