/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ComponentTableCellRenderer
implements TableCellRenderer {
    private boolean defaultOpaque = false;
    private boolean reactToSelection = true;
    private boolean backgroundWithStripes = false;

    public ComponentTableCellRenderer() {
    }

    public ComponentTableCellRenderer(boolean defaultOpaque) {
        this.defaultOpaque = defaultOpaque;
    }

    public ComponentTableCellRenderer(boolean defaultOpaque, boolean reactToSelection) {
        this.defaultOpaque = defaultOpaque;
        this.reactToSelection = reactToSelection;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Component)) {
            throw new IllegalArgumentException("Argument 'value' is not java.awt.Component");
        }
        Component component = (Component)value;
        if (this.reactToSelection) {
            if (isSelected) {
                component.setForeground(table.getSelectionForeground());
                component.setBackground(table.getSelectionBackground());
            } else {
                component.setForeground(table.getForeground());
                if (this.backgroundWithStripes) {
                    if (row % 2 == 0) {
                        Component temp = table.getDefaultRenderer(Object.class).getTableCellRendererComponent(table, "aqq", false, hasFocus, row, column);
                        ((JComponent)component).setBackground(temp.getBackground());
                    } else {
                        ((JComponent)component).setBackground(Color.WHITE);
                    }
                } else {
                    component.setBackground(table.getBackground());
                }
            }
        } else if (this.backgroundWithStripes) {
            if (row % 2 == 0) {
                Component temp = table.getDefaultRenderer(Object.class).getTableCellRendererComponent(table, "aqq", false, hasFocus, row, column);
                ((JComponent)component).setBackground(temp.getBackground());
            } else {
                ((JComponent)component).setBackground(Color.WHITE);
            }
        }
        if (this.defaultOpaque && component instanceof JComponent) {
            ((JComponent)component).setOpaque(true);
        }
        return component;
    }

    public boolean isDefaultOpaque() {
        return this.defaultOpaque;
    }

    public void setDefaultOpaque(boolean defaultOpaque) {
        this.defaultOpaque = defaultOpaque;
    }

    public boolean isReactToSelection() {
        return this.reactToSelection;
    }

    public void setReactToSelection(boolean reactToSelection) {
        this.reactToSelection = reactToSelection;
    }

    public boolean isBackgroundWithStripes() {
        return this.backgroundWithStripes;
    }

    public void setBackgroundWithStripes(boolean backgroundWithStripes) {
        this.backgroundWithStripes = backgroundWithStripes;
    }
}

