/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.rsa;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class RSAVerifier {
    private PublicKey publicKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAVerifier(File certificate) throws Exception {
        try (FileInputStream is = null;){
            is = new FileInputStream(certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
            this.publicKey = cert.getPublicKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAVerifier(byte[] certificate) throws Exception {
        try (ByteArrayInputStream is = null;){
            is = new ByteArrayInputStream(certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
            this.publicKey = cert.getPublicKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(InputStream is, byte[] signatureBytes) throws Exception {
        Signature publicSignature = Signature.getInstance("SHA256withRSA");
        publicSignature.initVerify(this.publicKey);
        byte[] buffer = new byte[4096];
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(is);
            int len = 0;
            while ((len = bis.read(buffer)) > 0) {
                publicSignature.update(buffer, 0, len);
            }
        }
        return publicSignature.verify(signatureBytes);
    }

    public boolean verify(byte[] plain, byte[] signatureBytes) throws Exception {
        return this.verify(new ByteArrayInputStream(plain), signatureBytes);
    }

    public boolean verify(File file, byte[] signatureBytes) throws Exception {
        return this.verify(new FileInputStream(file), signatureBytes);
    }
}

