/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.rsa;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;

public class RSASigner {
    public static final String SHA256withRSA = "SHA256withRSA";
    private PrivateKey privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSASigner(File keyStoreFile, String keyAlias, char[] keyPassword) throws Exception {
        KeyStore keyStoreP12 = KeyStore.getInstance("pkcs12");
        try (FileInputStream is = null;){
            is = new FileInputStream(keyStoreFile);
            keyStoreP12.load(is, keyPassword);
        }
        this.privateKey = (PrivateKey)keyStoreP12.getKey(keyAlias, keyPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(InputStream is) throws Exception {
        Signature privateSignature = Signature.getInstance(SHA256withRSA);
        privateSignature.initSign(this.privateKey);
        byte[] buffer = new byte[4096];
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(is);
            int len = 0;
            while ((len = bis.read(buffer)) > 0) {
                privateSignature.update(buffer, 0, len);
            }
        }
        return privateSignature.sign();
    }

    public byte[] sign(byte[] data) throws Exception {
        return this.sign(new ByteArrayInputStream(data));
    }

    public byte[] sign(File file) throws Exception {
        return this.sign(new FileInputStream(file));
    }
}

