/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.net;

public class SimpleURLEncoder {
    private SimpleURLEncoder() {
    }

    private static String getHex(int ch) {
        String hex = Integer.toHexString(ch);
        hex = hex.length() == 1 ? "%0" + hex : "%" + hex;
        return hex;
    }

    public static String encode(String s2, boolean encodeFractionSlash) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch = s2.charAt(i2);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9') {
                result.append(ch);
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                result.append(ch);
                continue;
            }
            if (!encodeFractionSlash && ch == '/') {
                result.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                result.append(SimpleURLEncoder.getHex(ch));
                continue;
            }
            if (ch <= '\u07ff') {
                result.append(SimpleURLEncoder.getHex(0xC0 | ch >> 6));
                result.append(SimpleURLEncoder.getHex(0x80 | ch & 0x3F));
                continue;
            }
            result.append(SimpleURLEncoder.getHex(0xE0 | ch >> 12));
            result.append(SimpleURLEncoder.getHex(0x80 | ch >> 6 & 0x3F));
            result.append(SimpleURLEncoder.getHex(0x80 | ch & 0x3F));
        }
        return result.toString();
    }
}

