/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.net.ProxyProperties;
import pl.com.kir.util.net.ProxyProtocol;

public class ProxyManager {
    private static ProxyManager instance = null;
    private TreeMap<ProxyProtocol, ProxyProperties> proxyMap = new TreeMap();

    private ProxyManager() {
    }

    public static synchronized ProxyManager getInstance() {
        if (instance == null) {
            instance = new ProxyManager();
        }
        return instance;
    }

    public synchronized void setProxy(ProxyProtocol protocol, ProxyProperties proxy) {
        ParameterValidator.assertNotNull("protocol", (Object)protocol);
        if (proxy != null) {
            this.proxyMap.put(protocol, new ProxyProperties(proxy));
        } else {
            this.proxyMap.remove((Object)protocol);
        }
        this.setProxyInTheSystem();
    }

    public synchronized void removeProxy(ProxyProtocol protocol) {
        ParameterValidator.assertNotNull("protocol", (Object)protocol);
        this.proxyMap.remove((Object)protocol);
        this.setProxyInTheSystem();
    }

    public synchronized void removeAllProxy() {
        this.proxyMap.clear();
        this.setProxyInTheSystem();
    }

    public synchronized ProxyProperties getProxy(ProxyProtocol protocol) {
        ParameterValidator.assertNotNull("protocol", (Object)protocol);
        ProxyProperties result = this.proxyMap.get((Object)protocol);
        if (result != null) {
            result = new ProxyProperties(result);
        }
        return result;
    }

    public synchronized Set<ProxyProtocol> getProtocolSet() {
        return new TreeSet<ProxyProtocol>(this.proxyMap.keySet());
    }

    public synchronized void setProxyInTheSystem() {
        if (this.proxyMap.size() == 0) {
            System.setProperty("java.net.useSystemProxies", "true");
            for (int i2 = 0; i2 < ProxyProtocol.values().length; ++i2) {
                ProxyProtocol protocol = ProxyProtocol.values()[i2];
                String protocolText = protocol.name().toLowerCase();
                System.clearProperty(protocolText + ".proxyHost");
                System.clearProperty(protocolText + ".proxyPort");
                System.clearProperty(protocolText + ".proxyUser");
                System.clearProperty(protocolText + ".proxyPassword");
                System.clearProperty(protocolText + ".nonProxyHosts");
            }
        } else {
            System.clearProperty("java.net.useSystemProxies");
            for (ProxyProtocol protocol : this.proxyMap.keySet()) {
                ProxyProperties proxy = this.proxyMap.get((Object)protocol);
                String protocolText = protocol.name().toLowerCase();
                ProxyManager.setSystemProp(protocolText + ".proxyHost", proxy.getProxyHost());
                ProxyManager.setSystemProp(protocolText + ".proxyPort", proxy.getProxyPort());
                ProxyManager.setSystemProp(protocolText + ".proxyUser", proxy.getProxyUser());
                ProxyManager.setSystemProp(protocolText + ".proxyPassword", proxy.getProxyPassword());
                ProxyManager.setSystemProp(protocolText + ".nonProxyHosts", proxy.getNonProxyHosts());
            }
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }

    private static void setSystemProp(String propName, String propValue) {
        ParameterValidator.assertNotEmpty("propName", propName);
        if (StringUtil.isEmpty(propValue)) {
            System.clearProperty(propName);
        } else {
            System.setProperty(propName, propValue);
        }
    }

    public static void main(String[] args) {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> pl = ProxySelector.getDefault().select(new URI("http://interia.pl/"));
            for (Proxy p2 : pl) {
                System.out.println(p2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ProxyAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            ProxyProperties proxy;
            ProxyProtocol protocol = null;
            if (this.getRequestingURL() != null) {
                String protocolText = this.getRequestingURL().getProtocol();
                protocol = ProxyProtocol.valueOf(protocolText.toUpperCase());
            }
            if (protocol == null) {
                protocol = ProxyProtocol.HTTP;
            }
            if ((proxy = (ProxyProperties)ProxyManager.this.proxyMap.get((Object)protocol)) != null) {
                return new PasswordAuthentication(proxy.getProxyUser(), proxy.getProxyPassword().toCharArray());
            }
            return new PasswordAuthentication("", "".toCharArray());
        }
    }
}

