/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.ProgressListener;
import pl.com.kir.util.StringUtil;

public class InternetHelper {
    private int bufferSize = 2024;
    private Proxy proxy = null;
    private ArrayList<ProgressListener> progressListener = new ArrayList();

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        ParameterValidator.assertRange("bufferSize", bufferSize, 1, 0x400000);
        this.bufferSize = bufferSize;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListener.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListener.remove(listener);
    }

    public byte[] get(URL url) throws IOException {
        ParameterValidator.assertNotNull("url", url);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.download(url, result, -1L, -1L);
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long save(URL url, File file) throws IOException {
        ParameterValidator.assertNotNull("url", url);
        ParameterValidator.assertNotNull("file", file);
        file.getParentFile().mkdirs();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            this.download(url, out, -1L, -1L);
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long save(URL url, File file, long rangeMin, long rangeMax) throws IOException {
        ParameterValidator.assertNotNull("url", url);
        ParameterValidator.assertNotNull("file", file);
        file.getParentFile().mkdirs();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file, true);
            this.download(url, out, rangeMin, rangeMax);
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(URL url, OutputStream outputStream, long rangeMin, long rangeMax) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        HttpURLConnection conn = null;
        conn = this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        InputStream is = null;
        try {
            if (rangeMin >= 0L && rangeMin < rangeMax) {
                conn.setRequestProperty("Range", "bytes=" + rangeMin + "-" + rangeMax);
            }
            is = conn.getInputStream();
            int size = 0;
            int summarySize = 0;
            while ((size = is.read(buffer)) > 0) {
                outputStream.write(buffer, 0, size);
                this.progress(url, summarySize += size);
            }
            this.finish(url);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (outputStream != null) {
                outputStream.flush();
            }
        }
    }

    public String getText(URL url) throws IOException {
        ParameterValidator.assertNotNull("url", url);
        return this.getText(url, null);
    }

    public String getText(URL url, String charsetName) throws IOException {
        ParameterValidator.assertNotNull("url", url);
        if (charsetName != null && charsetName.length() > 0) {
            return new String(this.get(url), charsetName);
        }
        return StringUtil.toString(this.get(url));
    }

    private void progress(URL url, long downloadSize) {
        for (ProgressListener listener : this.progressListener) {
            listener.progress(url, downloadSize);
        }
    }

    private void finish(URL url) {
        for (ProgressListener listener : this.progressListener) {
            listener.finish(url);
        }
    }
}

