/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.image;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.Timer;
import pl.com.kir.util.image.AbstractImageScaler;

public class TransparentImageScaler
extends AbstractImageScaler {
    @Override
    public String getDefaultTargetImageFormat() {
        return "png";
    }

    @Override
    public BufferedImage scale(BufferedImage imageSource, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        Timer timer = new Timer();
        timer.start();
        int sourceWidth = imageSource.getWidth(null);
        int sourceHeight = imageSource.getHeight(null);
        int targetWidth = width;
        int targetHeight = targetWidth * sourceHeight / sourceWidth;
        if (targetHeight > height) {
            targetHeight = height;
            targetWidth = targetHeight * sourceWidth / sourceHeight;
        }
        double scaleX = (double)targetWidth / (double)sourceWidth;
        double scaleY = (double)targetHeight / (double)sourceHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        BufferedImage imageTarget = bilinearScaleOp.filter(imageSource, new BufferedImage(targetWidth, targetHeight, imageSource.getType()));
        timer.stop();
        System.err.println("TransparentImageScaler.scale(..., " + width + ", " + height + ") -> " + timer.getTimeString());
        return imageTarget;
    }
}

