/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.image;

import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.Timer;
import pl.com.kir.util.image.AbstractImageScaler;

public class QualityImageScaler
extends AbstractImageScaler {
    @Override
    public BufferedImage scale(BufferedImage imageSource, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        Timer timer = new Timer();
        timer.start();
        int widthIN = imageSource.getWidth(null);
        int heightIN = imageSource.getHeight(null);
        int widthOUT = width;
        int heightOUT = widthOUT * heightIN / widthIN;
        if (heightOUT > height) {
            heightOUT = height;
            widthOUT = heightOUT * widthIN / heightIN;
        }
        float scaleX = (float)widthIN / (float)widthOUT;
        float scaleY = (float)heightIN / (float)heightOUT;
        scaleY = scaleX = Math.max(scaleX, scaleY);
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(Math.round((float)widthIN / scaleX), Math.round((float)heightIN / scaleY));
        FilteredImageSource producer = new FilteredImageSource(imageSource.getSource(), scaleFilter);
        ImageGenerator generator = new ImageGenerator();
        producer.startProduction(generator);
        BufferedImage imageTarget = generator.getImage();
        timer.stop();
        System.err.println("QualityPhotoScaler.scale(..., " + width + ", " + height + ") -> " + timer.getTimeString());
        return imageTarget;
    }

    private class ImageGenerator
    implements ImageConsumer {
        private Object holder = new Object();
        private ColorModel colorModel;
        private WritableRaster raster;
        private int width = -1;
        private int height = -1;
        private BufferedImage image;
        private int[] intBuffer;
        private boolean loadComplete = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imageComplete(int status) {
            Object object = this.holder;
            synchronized (object) {
                this.loadComplete = true;
                this.holder.notify();
            }
        }

        @Override
        public void setColorModel(ColorModel model) {
            this.colorModel = model;
            this.createImage();
        }

        @Override
        public void setDimensions(int w2, int h2) {
            this.width = w2;
            this.height = h2;
            this.createImage();
        }

        @Override
        public void setHints(int flags) {
        }

        @Override
        public void setPixels(int x2, int y2, int w2, int h2, ColorModel model, byte[] pixels, int offset, int scansize) {
            if (this.intBuffer == null || pixels.length > this.intBuffer.length) {
                this.intBuffer = new int[pixels.length];
            }
            for (int i2 = pixels.length - 1; i2 >= 0; --i2) {
                this.intBuffer[i2] = pixels[i2] & 0xFF;
            }
            this.raster.setPixels(x2, y2, w2, h2, this.intBuffer);
        }

        @Override
        public void setPixels(int x2, int y2, int w2, int h2, ColorModel model, int[] pixels, int offset, int scansize) {
            this.image.setRGB(x2, y2, w2, h2, pixels, offset, scansize);
        }

        public void setProperties(Hashtable props) {
            this.createImage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getImage() {
            if (!this.loadComplete) {
                Object object = this.holder;
                synchronized (object) {
                    try {
                        this.holder.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return this.image;
        }

        private void createImage() {
            if (this.image != null || this.width == -1 || this.colorModel == null) {
                return;
            }
            this.image = new BufferedImage(this.width, this.height, 1);
        }
    }
}

