/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pl.com.kir.util.ParameterValidator;

public class ImageHelper {
    private ImageHelper() {
    }

    public static Image icon2image(Icon icon) {
        ParameterValidator.assertNotNull("icon", icon);
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        icon.paintIcon(null, image.getGraphics(), 0, 0);
        return image;
    }

    public static BufferedImage image2bufferedImage(Image image) {
        ParameterValidator.assertNotNull("image", image);
        BufferedImage result = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graph = result.getGraphics();
        graph.drawImage(image, 0, 0, null);
        graph.dispose();
        return result;
    }

    public static BufferedImage imageIcon2bufferedImage(ImageIcon imageIcon) {
        ParameterValidator.assertNotNull("imageIcon", imageIcon);
        return ImageHelper.image2bufferedImage(imageIcon.getImage());
    }

    public static BufferedImage icon2bufferedImage(Icon icon) {
        ParameterValidator.assertNotNull("icon", icon);
        return ImageHelper.image2bufferedImage(ImageHelper.icon2image(icon));
    }

    public static void saveJPG(BufferedImage image, File targetFile, float quality) throws IOException {
        ParameterValidator.assertNotNull("image", image);
        ParameterValidator.assertNotNull("targetFile", targetFile);
        ParameterValidator.assertPositiveNumber("quality", quality);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        JPEGImageWriteParam jpegParam = new JPEGImageWriteParam(null);
        jpegParam.setCompressionMode(2);
        jpegParam.setCompressionQuality(quality);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("jpg");
        ImageWriter writer = iterator.next();
        FileImageOutputStream out = new FileImageOutputStream(targetFile);
        writer.setOutput(out);
        writer.write(null, new IIOImage(image, null, null), jpegParam);
        writer.dispose();
        out.flush();
        out.close();
    }

    public static byte[] bufferedImage2byteArray(BufferedImage bufferedImage, String targetImageFormat) {
        ParameterValidator.assertNotNull("bufferedImage", bufferedImage);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        byte[] result = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, targetImageFormat, out);
            out.flush();
            result = out.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }
}

