/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.image;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import javax.swing.ImageIcon;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.Timer;
import pl.com.kir.util.image.AbstractImageScaler;

public class FastImageScaler
extends AbstractImageScaler {
    @Override
    public BufferedImage scale(BufferedImage imageSource, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        Timer timer = new Timer();
        timer.start();
        int widthIN = imageSource.getWidth();
        int heightIN = imageSource.getHeight();
        int widthOUT = width;
        int heightOUT = widthOUT * heightIN / widthIN;
        if (heightOUT > height) {
            heightOUT = height;
            widthOUT = heightOUT * widthIN / heightIN;
        }
        ReplicateScaleFilter replicate = new ReplicateScaleFilter(widthOUT, heightOUT);
        FilteredImageSource producer = new FilteredImageSource(imageSource.getSource(), replicate);
        Image imageOUT = new Canvas().createImage(producer);
        ImageIcon imageIcon = new ImageIcon(imageOUT);
        BufferedImage imageTarget = new BufferedImage(widthOUT, heightOUT, 1);
        Graphics2D graphics2D = imageTarget.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        timer.stop();
        System.err.println("FastPhotoScaler.scale() -> " + timer.getTimeString());
        return imageTarget;
    }
}

