/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.image;

import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.image.ImageHelper;
import pl.com.kir.util.image.ImageScaler;

public abstract class AbstractImageScaler
implements ImageScaler {
    public String getDefaultTargetImageFormat() {
        return "jpg";
    }

    @Override
    public abstract BufferedImage scale(BufferedImage var1, int var2, int var3, String var4);

    @Override
    public BufferedImage scale(BufferedImage imageSource, int width, int height) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        return this.scale(imageSource, width, height, this.getDefaultTargetImageFormat());
    }

    @Override
    public ImageIcon scale(ImageIcon imageSource, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        return new ImageIcon(this.scale(ImageHelper.imageIcon2bufferedImage(imageSource), width, height, targetImageFormat));
    }

    @Override
    public ImageIcon scale(ImageIcon imageSource, int width, int height) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        return this.scale(imageSource, width, height, this.getDefaultTargetImageFormat());
    }

    @Override
    public Icon scale(Icon imageSource, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        return new ImageIcon(this.scale(ImageHelper.icon2bufferedImage(imageSource), width, height, targetImageFormat));
    }

    @Override
    public Icon scale(Icon imageSource, int width, int height) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        return this.scale(imageSource, width, height, this.getDefaultTargetImageFormat());
    }

    @Override
    public byte[] scale(byte[] image, int width, int height, String targetImageFormat) {
        ParameterValidator.assertNotNull("image", image);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        ParameterValidator.assertNotEmpty("targetImageFormat", targetImageFormat);
        BufferedImage imageSource = ImageHelper.image2bufferedImage(new ImageIcon(image).getImage());
        BufferedImage imageTarget = this.scale(imageSource, width, height, targetImageFormat);
        return ImageHelper.bufferedImage2byteArray(imageTarget, targetImageFormat);
    }

    @Override
    public byte[] scale(byte[] imageSource, int width, int height) {
        ParameterValidator.assertNotNull("imageSource", imageSource);
        ParameterValidator.assertPositiveNumber("width", width);
        ParameterValidator.assertPositiveNumber("height", height);
        return this.scale(imageSource, width, height, this.getDefaultTargetImageFormat());
    }
}

