/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pl.com.kir.util.html.HTMLSimpleAttr;
import pl.com.kir.util.html.HTMLSimpleElement;

public class HTMLSimpleTag
implements HTMLSimpleElement {
    private int formattingLevel = 0;
    private String formattingPadStr = "";
    private TagName tagName = null;
    private String tagInnerText = null;
    private TreeMap<String, HTMLSimpleAttr> attributes = new TreeMap();
    private List<HTMLSimpleTag> subElements = new ArrayList<HTMLSimpleTag>();

    public HTMLSimpleTag(TagName tagName) {
        this.tagName = tagName;
        this.setFormattingLevel(0);
    }

    public HTMLSimpleTag(String tagInnerText) {
        this(TagName._TEXT);
        this.tagInnerText = tagInnerText;
    }

    public void setFormattingLevel(int formattingLevel) {
        this.formattingLevel = formattingLevel;
        for (int i2 = 0; i2 < formattingLevel; ++i2) {
            this.formattingPadStr = this.formattingPadStr + " ";
        }
        for (HTMLSimpleTag simpleTag : this.subElements) {
            simpleTag.setFormattingLevel(formattingLevel + 1);
        }
    }

    public int getFormattingLevel() {
        return this.formattingLevel;
    }

    public HTMLSimpleTag addTag(HTMLSimpleTag simpleTag) {
        this.subElements.add(simpleTag);
        simpleTag.setFormattingLevel(this.getFormattingLevel() + 1);
        return simpleTag;
    }

    public HTMLSimpleTag addTag(TagName tagName) {
        return this.addTag(new HTMLSimpleTag(tagName));
    }

    public HTMLSimpleTag appendText(String text) {
        return this.addTag(new HTMLSimpleTag(text));
    }

    public HTMLSimpleTag addAttribute(HTMLSimpleAttr simpleAttr) {
        this.attributes.put(simpleAttr.getName(), simpleAttr);
        return this;
    }

    public HTMLSimpleTag addAttribute(HTMLSimpleAttr.AttrName attrName, String attrValue) {
        this.addAttribute(new HTMLSimpleAttr(attrName, attrValue));
        return this;
    }

    protected StringBuilder openTag(StringBuilder sb) {
        sb.append(String.format("\n%s<%s", this.formattingPadStr, this.tagName.toString().toLowerCase()));
        this.joinAttrs(sb);
        if (!this.subElements.isEmpty()) {
            sb.append(">");
        }
        return sb;
    }

    protected StringBuilder joinAttrs(StringBuilder sb) {
        for (Map.Entry<String, HTMLSimpleAttr> entry : this.attributes.entrySet()) {
            sb.append(" ");
            entry.getValue().toStringBuilder(sb);
        }
        return sb;
    }

    protected StringBuilder closeTag(StringBuilder sb) {
        sb.append(this.subElements.size() == 0 ? " />" : String.format("\n%s</%s>", this.formattingPadStr, this.tagName.toString().toLowerCase()));
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        if (this.tagName.equals((Object)TagName._TEXT)) {
            sb.append(this.tagInnerText);
        } else {
            this.openTag(sb);
            for (HTMLSimpleTag simpleTag : this.subElements) {
                simpleTag.toStringBuilder(sb);
            }
            this.closeTag(sb);
        }
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        HTMLSimpleTag table = new HTMLSimpleTag(TagName.TABLE);
        table.addAttribute(HTMLSimpleAttr.AttrName.BORDER, "1").addAttribute(HTMLSimpleAttr.AttrName.CELLPADDING, "3").addAttribute(HTMLSimpleAttr.AttrName.CELLPADDING, "3").addAttribute(HTMLSimpleAttr.AttrName.CELLSPACING, "2").addAttribute(HTMLSimpleAttr.AttrName.WIDTH, "100%");
        for (int i2 = 0; i2 < 10; ++i2) {
            HTMLSimpleTag trTag = new HTMLSimpleTag(TagName.TR);
            trTag.addAttribute(HTMLSimpleAttr.AttrName.CLASS, "abc");
            trTag.addTag(TagName.TD).addAttribute(HTMLSimpleAttr.AttrName.BGCOLOR, "#FFF").addAttribute(HTMLSimpleAttr.AttrName.CLASS, "tdOdd").appendText("NIE TAKA BLADA");
            trTag.addTag(TagName.TD);
            trTag.addTag(TagName.TD).addAttribute(HTMLSimpleAttr.AttrName.BGCOLOR, "#AAA");
            trTag.appendText("\nOJOJ");
            table.addTag(trTag);
        }
        table.toStringBuilder(sb);
        System.out.println(sb);
    }

    public static enum TagName {
        _TEXT,
        A,
        ABBR,
        ACRONYM,
        ADDRESS,
        APPLET,
        AREA,
        ARTICLE,
        ASIDE,
        AUDIO,
        B,
        BASE,
        BASEFONT,
        BDI,
        BDO,
        BIG,
        BLOCKQUOTE,
        BODY,
        BR,
        BUTTON,
        CANVAS,
        CAPTION,
        CENTER,
        CITE,
        CODE,
        COL,
        COLGROUP,
        COMMAND,
        DATALIST,
        DD,
        DEL,
        DETAILS,
        DFN,
        DIALOG,
        DIR,
        DIV,
        DL,
        DT,
        EM,
        EMBED,
        FIELDSET,
        FIGCAPTION,
        FIGURE,
        FONT,
        FOOTER,
        FORM,
        FRAME,
        FRAMESET,
        HEAD,
        HEADER,
        H6,
        HR,
        HTML,
        I,
        IFRAME,
        IMG,
        INPUT,
        INS,
        KBD,
        KEYGEN,
        LABEL,
        LEGEND,
        LI,
        LINK,
        MAP,
        MARK,
        MENU,
        META,
        METER,
        NAV,
        NOFRAMES,
        NOSCRIPT,
        OBJECT,
        OL,
        OPTGROUP,
        OPTION,
        OUTPUT,
        P,
        PARAM,
        PRE,
        PROGRESS,
        Q,
        RP,
        RT,
        RUBY,
        S,
        SAMP,
        SCRIPT,
        SECTION,
        SELECT,
        SMALL,
        SOURCE,
        SPAN,
        STRIKE,
        STRONG,
        STYLE,
        SUB,
        SUMMARY,
        SUP,
        TABLE,
        TBODY,
        TD,
        TEXTAREA,
        TFOOT,
        TH,
        THEAD,
        TIME,
        TITLE,
        TR,
        TRACK,
        TT,
        U,
        UL,
        VAR,
        VIDEO,
        WBR;

    }
}

