/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.html;

import java.util.ArrayList;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.StringUtil;
import pl.com.kir.util.html.HTMLAlignAttributes;
import pl.com.kir.util.html.HTMLFontAttributes;
import pl.com.kir.util.html.HTMLSizeAttributes;
import pl.com.kir.util.html.HTMLTableAttributes;
import pl.com.kir.util.html.HTMLTextAttributes;
import pl.com.kir.util.xml.XMLBuilder;

public class HTMLBuilder {
    private static final String[][] SPECIAL_CHARACTERS = new String[][]{{"&amp;nbsp;", "&nbsp;"}};
    private XMLBuilder builder = new XMLBuilder();
    private ArrayList<TableInfo> tableInfoList = new ArrayList();

    public int length() {
        return this.builder.length();
    }

    public String toString() {
        return this.builder.toXMLString();
    }

    public String toHTMLString() {
        String result = null;
        StringBuffer buffer = this.builder.getBuffer();
        buffer.insert(0, "<html>");
        buffer.append("</html>");
        result = buffer.toString();
        for (int i2 = 0; i2 < SPECIAL_CHARACTERS.length; ++i2) {
            result = StringUtil.replace(result, SPECIAL_CHARACTERS[i2][0], SPECIAL_CHARACTERS[i2][1]);
        }
        buffer.delete(0, 5);
        buffer.delete(buffer.length() - 7, buffer.length() - 1);
        return result;
    }

    public void addText(String text) {
        this.addText(text, null);
    }

    public void addText(String text, HTMLTextAttributes attr) {
        if (attr != null) {
            if (attr.getColor() != null || attr.getSize() != null) {
                this.openFONT(attr);
            }
            if (attr.isBold()) {
                this.builder.openTag("b");
            }
            if (attr.isItalic()) {
                this.builder.openTag("i");
            }
        }
        this.builder.addString(text);
        if (attr != null) {
            if (attr.isItalic()) {
                this.builder.closeTag("i");
            }
            if (attr.isBold()) {
                this.builder.closeTag("b");
            }
            if (attr.getColor() != null || attr.getSize() != null) {
                this.closeFONT();
            }
        }
    }

    public void addHTMLText(String htmlText) {
        this.addHTMLText(htmlText, null);
    }

    public void addHTMLText(String htmlText, HTMLTextAttributes attr) {
        if (attr != null) {
            if (attr.getColor() != null || attr.getSize() != null) {
                this.openFONT(attr);
            }
            if (attr.isBold()) {
                this.builder.openTag("b");
            }
            if (attr.isItalic()) {
                this.builder.openTag("i");
            }
        }
        this.builder.addXMLString(htmlText);
        if (attr != null) {
            if (attr.isItalic()) {
                this.builder.closeTag("i");
            }
            if (attr.isBold()) {
                this.builder.closeTag("b");
            }
            if (attr.getColor() != null || attr.getSize() != null) {
                this.closeFONT();
            }
        }
    }

    public void addBR() {
        this.builder.openTag("br");
    }

    public void addBR(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.addBR();
        }
    }

    public void addHR() {
        this.builder.openTag("hr");
    }

    public void openTABLE() {
        this.tableInfoList.add(new TableInfo(new HTMLTableAttributes()));
        this.builder.openTag("table");
    }

    public void openTABLE(HTMLTableAttributes attr) {
        if (attr == null) {
            attr = new HTMLTableAttributes();
        }
        this.tableInfoList.add(new TableInfo(attr));
        this.builder.startOpenTag("table");
        if (attr.getBorder() >= 0) {
            this.builder.addAttribute("border", attr.getBorder());
        }
        if (attr.getBorderColor() != null) {
            this.builder.addAttribute("bordercolor", attr.getBorderColor());
        }
        if (attr.getBgColor() != null) {
            this.builder.addAttribute("bgcolor", attr.getBgColor());
        }
        if (attr.getWidth() != null) {
            this.builder.addAttribute("width", attr.getWidth());
        }
        if (attr.getHeight() != null) {
            this.builder.addAttribute("height", attr.getHeight());
        }
        this.builder.endOpenTag();
    }

    public void closeTABLE() {
        if (this.tableInfoList.size() > 0) {
            this.tableInfoList.remove(this.tableInfoList.size() - 1);
        }
        this.builder.closeTag("table");
    }

    public void openTR() {
        this.openTR(null);
    }

    public void openTR(String bgcolor) {
        TableInfo tableInfo = this.getTableInfo();
        if (tableInfo != null) {
            int idx = tableInfo.getRowIndex();
            if (bgcolor == null) {
                bgcolor = tableInfo.getAttr().getBgColorFirstRow() != null && idx == 0 ? tableInfo.getAttr().getBgColorFirstRow() : ((idx + 1) % 2 == 0 ? tableInfo.getAttr().getBgColorEvenRow() : tableInfo.getAttr().getBgColorOddRow());
            }
        }
        this.builder.startOpenTag("tr");
        this.builder.addAttribute("bgcolor", bgcolor);
        this.builder.endOpenTag();
    }

    public void closeTR() {
        this.builder.closeTag("tr");
    }

    public void openTD() {
        this.builder.openTag("td");
    }

    public void openTD(String bgcolor) {
        this.builder.startOpenTag("td");
        this.builder.addAttribute("bgcolor", bgcolor);
        this.builder.endOpenTag();
    }

    public void openTD(int colspan) {
        this.builder.startOpenTag("td");
        this.builder.addAttribute("colspan", colspan);
        this.builder.endOpenTag();
    }

    public void openTD(HTMLSizeAttributes sizeAttr, HTMLAlignAttributes alignAttr, String bgcolor) {
        this.builder.startOpenTag("td");
        if (sizeAttr != null) {
            if (sizeAttr.getWidth() != null) {
                this.builder.addAttribute("width", sizeAttr.getWidth());
            }
            if (sizeAttr.getHeight() != null) {
                this.builder.addAttribute("height", sizeAttr.getHeight());
            }
        }
        if (alignAttr != null) {
            if (alignAttr.getAlign() != null) {
                this.builder.addAttribute("align", alignAttr.getAlign());
            }
            if (alignAttr.getValign() != null) {
                this.builder.addAttribute("valign", alignAttr.getValign());
            }
        }
        if (bgcolor != null) {
            this.builder.addAttribute("bgcolor", bgcolor);
        }
        this.builder.endOpenTag();
    }

    public void openTD(HTMLSizeAttributes sizeAttr, HTMLAlignAttributes alignAttr) {
        this.openTD(sizeAttr, alignAttr, null);
    }

    public void openTD(HTMLSizeAttributes sizeAttr) {
        this.openTD(sizeAttr, null);
    }

    public void openTD(HTMLAlignAttributes alignAttr) {
        this.openTD(null, alignAttr);
    }

    public void closeTD() {
        this.builder.closeTag("td");
    }

    public void addTD(String value) {
        if (value != null) {
            this.builder.addTag("td", value);
        } else {
            this.builder.addTag("td", "");
        }
    }

    public void addTD(String value, HTMLSizeAttributes sizeAttr, HTMLAlignAttributes alignAttr) {
        this.openTD(sizeAttr, alignAttr);
        this.addText(value);
        this.closeTD();
    }

    public void addTD(String value, HTMLSizeAttributes sizeAttr, HTMLAlignAttributes alignAttr, HTMLTextAttributes textAttr) {
        this.openTD(sizeAttr, alignAttr);
        this.addText(value, textAttr);
        this.closeTD();
    }

    public void addTD(String value, HTMLSizeAttributes sizeAttr) {
        this.addTD(value, sizeAttr, null);
    }

    public void addTD(String value, HTMLAlignAttributes alignAttr) {
        this.addTD(value, null, alignAttr);
    }

    public void addTD(String value, HTMLTextAttributes textAttr) {
        this.openTD();
        this.addText(value, textAttr);
        this.closeTD();
    }

    public void addNBSP() {
        this.builder.addXMLString("&nbsp;");
    }

    public void addNBSP(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.addNBSP();
        }
    }

    public void openFONT(HTMLFontAttributes attr) {
        this.builder.startOpenTag("font");
        if (attr != null) {
            if (attr.getColor() != null) {
                this.builder.addAttribute("color", attr.getColor());
            }
            if (attr.getSize() != null) {
                this.builder.addAttribute("size", attr.getSize());
            }
        }
        this.builder.endOpenTag();
    }

    public void closeFONT() {
        this.builder.closeTag("font");
    }

    public void addHTML(String html) {
        this.builder.addXMLString(html);
    }

    public void openBold() {
        this.builder.openTag("b");
    }

    public void closeBold() {
        this.builder.closeTag("b");
    }

    public void openItalic() {
        this.builder.openTag("i");
    }

    public void closeItalic() {
        this.builder.closeTag("i");
    }

    private TableInfo getTableInfo() {
        TableInfo result = null;
        if (this.tableInfoList.size() > 0) {
            result = this.tableInfoList.get(this.tableInfoList.size() - 1);
        }
        return result;
    }

    private class TableInfo {
        private HTMLTableAttributes attr = null;
        private int rowIndex = -1;

        public TableInfo(HTMLTableAttributes attr) {
            ParameterValidator.assertNotNull("attr", attr);
            this.attr = attr;
        }

        public HTMLTableAttributes getAttr() {
            return this.attr;
        }

        public int getRowIndex() {
            return ++this.rowIndex;
        }
    }
}

