/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.base64;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.base64.Base64DecodeInputStream;
import pl.com.kir.util.base64.Base64EncodeReader;

public class Base64Helper {
    private static final int BUFFER_SIZE = 0x400000;
    private static char[] mapToB64 = null;
    private static byte[] mapFromB64 = null;

    private Base64Helper() {
    }

    private static void initMaps() {
        if (mapToB64 == null) {
            int c2;
            mapToB64 = new char[64];
            int i2 = 0;
            for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
                Base64Helper.mapToB64[i2++] = c2;
            }
            for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
                Base64Helper.mapToB64[i2++] = c2;
            }
            for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
                Base64Helper.mapToB64[i2++] = c2;
            }
            Base64Helper.mapToB64[i2++] = 43;
            Base64Helper.mapToB64[i2++] = 47;
            mapFromB64 = new byte[128];
            for (i2 = 0; i2 < mapFromB64.length; ++i2) {
                Base64Helper.mapFromB64[i2] = -1;
            }
            for (i2 = 0; i2 < 64; ++i2) {
                Base64Helper.mapFromB64[Base64Helper.mapToB64[i2]] = (byte)i2;
            }
        }
    }

    static char[] getMapToB64() {
        Base64Helper.initMaps();
        return mapToB64;
    }

    static byte[] getMapFromB64() {
        Base64Helper.initMaps();
        return mapFromB64;
    }

    public static String encode(byte[] value) {
        ParameterValidator.assertNotNull("value", value);
        Base64Helper.initMaps();
        int dataLength = (value.length * 4 + 2) / 3;
        int resultLength = (value.length + 2) / 3 * 4;
        char[] result = new char[resultLength];
        int ip = 0;
        int op = 0;
        while (ip < value.length) {
            int i0 = value[ip++] & 0xFF;
            int i1 = ip < value.length ? value[ip++] & 0xFF : 0;
            int i2 = ip < value.length ? value[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            result[op++] = mapToB64[o0];
            result[op++] = mapToB64[o1];
            result[op] = op < dataLength ? mapToB64[o2] : 61;
            int n2 = ++op < dataLength ? mapToB64[o3] : 61;
            result[op] = n2;
            ++op;
        }
        return new String(result);
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        ParameterValidator.assertNotNull("in", in);
        ParameterValidator.assertNotNull("out", out);
        Base64Helper.initMaps();
        Base64EncodeReader reader = new Base64EncodeReader(in);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        char[] buffer = new char[0x400000];
        int readLength = 0;
        while ((readLength = reader.read(buffer)) > 0) {
            ((Writer)writer).write(buffer, 0, readLength);
        }
        ((Writer)writer).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(String value, boolean skipWhiteChars) throws IOException {
        ParameterValidator.assertNotNull("value", value);
        if (skipWhiteChars) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ByteArrayInputStream is = null;){
                is = new ByteArrayInputStream(value.getBytes());
                Base64Helper.decode(is, out);
            }
            return out.toByteArray();
        }
        return Base64Helper.decode(value.toCharArray());
    }

    public static byte[] decode(String value) {
        ParameterValidator.assertNotNull("value", value);
        return Base64Helper.decode(value.toCharArray());
    }

    public static byte[] decode(char[] charArray) {
        int inputLength;
        ParameterValidator.assertNotNull("charArray", charArray);
        Base64Helper.initMaps();
        if (inputLength % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        for (inputLength = charArray.length; inputLength > 0 && charArray[inputLength - 1] == '='; --inputLength) {
        }
        int resultLength = inputLength * 3 / 4;
        byte[] result = new byte[resultLength];
        int ip = 0;
        int op = 0;
        while (ip < inputLength) {
            int i3;
            char i0 = charArray[ip++];
            char i1 = charArray[ip++];
            int i2 = ip < inputLength ? charArray[ip++] : 65;
            int n2 = i3 = ip < inputLength ? charArray[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = mapFromB64[i0];
            byte b1 = mapFromB64[i1];
            byte b2 = mapFromB64[i2];
            byte b3 = mapFromB64[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            result[op++] = (byte)o0;
            if (op < resultLength) {
                result[op++] = (byte)o1;
            }
            if (op >= resultLength) continue;
            result[op++] = (byte)o2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(InputStream in, OutputStream out) throws IOException {
        ParameterValidator.assertNotNull("in", in);
        ParameterValidator.assertNotNull("out", out);
        Base64Helper.initMaps();
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        Base64DecodeInputStream is = null;
        try {
            is = new Base64DecodeInputStream(new InputStreamReader(in));
            byte[] buffer = new byte[0x400000];
            int readLength = 0;
            while ((readLength = ((InputStream)is).read(buffer)) > 0) {
                out.write(buffer, 0, readLength);
            }
        }
        finally {
            out.flush();
        }
    }

    public static String encodeObject(Object value) throws IOException {
        ParameterValidator.assertNotNull("value", value);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        objectOut.writeObject(value);
        objectOut.flush();
        objectOut.close();
        byte[] byteArray = out.toByteArray();
        return Base64Helper.encode(byteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeObject(String value) throws IOException, ClassNotFoundException {
        ParameterValidator.assertNotNull("value", value);
        byte[] byteArray = Base64Helper.decode(value);
        ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
        try (ObjectInputStream objectIn = new ObjectInputStream(in);){
            Object object = objectIn.readObject();
            return object;
        }
    }
}

