/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.base64.Base64Helper;

public class Base64FilterReader
extends Reader {
    private byte[] mapFromB64 = null;
    private Reader reader = null;
    private CharMagicBuffer readBuffer = new CharMagicBuffer(49152);

    public Base64FilterReader(InputStream inputStream) {
        ParameterValidator.assertNotNull("inputStream", inputStream);
        this.reader = new InputStreamReader(inputStream);
        this.mapFromB64 = Base64Helper.getMapFromB64();
    }

    public Base64FilterReader(Reader reader) {
        ParameterValidator.assertNotNull("reader", reader);
        this.reader = reader;
        this.mapFromB64 = Base64Helper.getMapFromB64();
    }

    private boolean accept(int value) {
        if (value >= 0 && value <= 127) {
            return this.mapFromB64[value] >= 0 || value == 61;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int outLength = 0;
        while (outLength < len) {
            if (this.readBuffer.getDataSize() <= 0) {
                int readLength = this.reader.read(this.readBuffer.buffer);
                this.readBuffer.beginIndex = 0;
                this.readBuffer.endIndex = readLength - 1;
                if (readLength <= 0) break;
            }
            while (outLength < len && this.readBuffer.getDataSize() > 0) {
                int value = this.readBuffer.read();
                if (!this.accept(value)) continue;
                cbuf[off + outLength] = (char)value;
                ++outLength;
            }
        }
        return outLength;
    }

    private class CharMagicBuffer {
        private char[] buffer = null;
        private int beginIndex = 0;
        private int endIndex = -1;

        public CharMagicBuffer(int bufferSize) {
            this.buffer = new char[bufferSize];
        }

        public int getDataSize() {
            return this.endIndex < 0 ? 0 : this.endIndex - this.beginIndex + 1;
        }

        public int read() {
            int result = -1;
            if (this.beginIndex <= this.endIndex) {
                result = this.buffer[this.beginIndex];
                ++this.beginIndex;
            }
            return result;
        }
    }
}

