/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.base64.Base64Helper;

public class Base64EncodeReader
extends Reader {
    private static final int READ_BUFFER_SIZE = 49152;
    private static final int RESULT_BUFFER_SIZE = 65536;
    private char[] mapToB64 = null;
    private InputStream is = null;
    private byte[] readBuffer = new byte[49152];
    private CharMagicBuffer resultBuffer = new CharMagicBuffer(65536);

    public Base64EncodeReader(InputStream inputStream) {
        ParameterValidator.assertNotNull("inputStream", inputStream);
        this.is = inputStream;
        this.mapToB64 = Base64Helper.getMapToB64();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.resultBuffer.getDataSize() > 0) {
            return true;
        }
        this.fillBuffer();
        return this.resultBuffer.getDataSize() > 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.resultBuffer.getDataSize() == 0) {
                this.fillBuffer();
                if (this.resultBuffer.getDataSize() == 0) break;
            }
            cbuf[off + i2] = (char)this.resultBuffer.read();
            ++result;
        }
        return result;
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        throw new RuntimeException("Method not implemented.");
    }

    private void fillBuffer() throws IOException {
        int readLength = 0;
        readLength = this.is.read(this.readBuffer);
        if (readLength > 0) {
            int dataLength = (readLength * 4 + 2) / 3;
            int ip = 0;
            int op = 0;
            while (ip < readLength) {
                int i0 = this.readBuffer[ip++] & 0xFF;
                int i1 = ip < readLength ? this.readBuffer[ip++] & 0xFF : 0;
                int i2 = ip < readLength ? this.readBuffer[ip++] & 0xFF : 0;
                int o0 = i0 >>> 2;
                int o1 = (i0 & 3) << 4 | i1 >>> 4;
                int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
                int o3 = i2 & 0x3F;
                ((CharMagicBuffer)this.resultBuffer).buffer[op++] = this.mapToB64[o0];
                ((CharMagicBuffer)this.resultBuffer).buffer[op++] = this.mapToB64[o1];
                ((CharMagicBuffer)this.resultBuffer).buffer[op] = op < dataLength ? this.mapToB64[o2] : 61;
                int n2 = ++op < dataLength ? this.mapToB64[o3] : 61;
                ((CharMagicBuffer)this.resultBuffer).buffer[op] = n2;
                ++op;
            }
            this.resultBuffer.beginIndex = 0;
            this.resultBuffer.endIndex = op - 1;
        }
    }

    private class CharMagicBuffer {
        private char[] buffer = null;
        private int beginIndex = 0;
        private int endIndex = -1;

        public CharMagicBuffer(int bufferSize) {
            this.buffer = new char[bufferSize];
        }

        public int getDataSize() {
            return this.endIndex < 0 ? 0 : this.endIndex - this.beginIndex + 1;
        }

        public int read() {
            int result = -1;
            if (this.beginIndex <= this.endIndex) {
                result = this.buffer[this.beginIndex];
                ++this.beginIndex;
            }
            return result;
        }
    }
}

