/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util.base64;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import pl.com.kir.util.ParameterValidator;
import pl.com.kir.util.base64.Base64FilterReader;
import pl.com.kir.util.base64.Base64Helper;

public class Base64DecodeInputStream
extends InputStream {
    private static final int READ_BUFFER_SIZE = 65536;
    private static final int RESULT_BUFFER_SIZE = 49152;
    private byte[] mapFromB64 = null;
    private Reader reader = null;
    private char[] readBuffer = new char[65536];
    private ByteMagicBuffer resultBuffer = new ByteMagicBuffer(49152);

    public Base64DecodeInputStream(Reader reader) {
        ParameterValidator.assertNotNull("reader", reader);
        this.reader = new Base64FilterReader(reader);
        this.mapFromB64 = Base64Helper.getMapFromB64();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.resultBuffer.getDataSize() == 0) {
            this.fillBuffer();
            if (this.resultBuffer.getDataSize() == 0) {
                return -1;
            }
        }
        return this.resultBuffer.read();
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.resultBuffer.getDataSize() == 0) {
                this.fillBuffer();
                if (this.resultBuffer.getDataSize() == 0) break;
            }
            b2[off + i2] = (byte)this.resultBuffer.read();
            ++result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        throw new RuntimeException("Method not implemented.");
    }

    private void fillBuffer() throws IOException {
        int readLength = 0;
        readLength = this.reader.read(this.readBuffer);
        if (readLength > 0) {
            while (readLength > 0 && this.readBuffer[readLength - 1] == '=') {
                --readLength;
            }
            int resultLength = readLength * 3 / 4;
            int ip = 0;
            int op = 0;
            while (ip < readLength) {
                char i0 = this.readBuffer[ip++];
                char i1 = this.readBuffer[ip++];
                int i2 = ip < readLength ? this.readBuffer[ip++] : 65;
                int i3 = ip < readLength ? this.readBuffer[ip++] : 65;
                byte b0 = this.mapFromB64[i0];
                byte b1 = this.mapFromB64[i1];
                byte b2 = this.mapFromB64[i2];
                byte b3 = this.mapFromB64[i3];
                int o0 = b0 << 2 | b1 >>> 4;
                int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
                int o2 = (b2 & 3) << 6 | b3;
                ((ByteMagicBuffer)this.resultBuffer).buffer[op++] = (byte)o0;
                if (op < resultLength) {
                    ((ByteMagicBuffer)this.resultBuffer).buffer[op++] = (byte)o1;
                }
                if (op >= resultLength) continue;
                ((ByteMagicBuffer)this.resultBuffer).buffer[op++] = (byte)o2;
            }
            this.resultBuffer.beginIndex = 0;
            this.resultBuffer.endIndex = op - 1;
        }
    }

    private class ByteMagicBuffer {
        private byte[] buffer = null;
        private int beginIndex = 0;
        private int endIndex = -1;

        public ByteMagicBuffer(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }

        public int getDataSize() {
            return this.endIndex < 0 ? 0 : this.endIndex - this.beginIndex + 1;
        }

        public int read() {
            int result = -1;
            if (this.beginIndex <= this.endIndex) {
                result = this.buffer[this.beginIndex];
                ++this.beginIndex;
            }
            return result;
        }
    }
}

