/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import pl.com.kir.util.StringUtil;

public class Timer {
    private long time = 0L;
    private long startTime = 0L;
    private long stopTime = 0L;
    private boolean active = false;

    public long getMillisecounds() {
        if (this.active) {
            return System.currentTimeMillis() - this.startTime + this.time;
        }
        return this.time;
    }

    public long getSecounds() {
        return this.getMillisecounds() / 1000L;
    }

    public String getTimeString() {
        return Timer.getTimeString(this.getMillisecounds());
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean start() {
        if (!this.active) {
            this.active = true;
            this.startTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public boolean stop() {
        if (this.active) {
            this.active = false;
            this.stopTime = System.currentTimeMillis();
            this.time += this.stopTime - this.startTime;
            return true;
        }
        return false;
    }

    public void reset() {
        this.active = false;
        this.time = 0L;
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public static String getTimeString(long timeInMillisecounds) {
        long value = timeInMillisecounds;
        int millisecounds = (int)(value % 1000L);
        int days = (int)((value /= 1000L) / 86400L);
        int hours = (int)((value -= (long)(days * 3600 * 24)) / 3600L);
        int minutes = (int)((value -= (long)(hours * 3600)) / 60L);
        int secounds = (int)(value -= (long)(minutes * 60));
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(days);
        buffer.append(") ");
        buffer.append(StringUtil.fillLeft(Integer.toString(hours), 2, '0'));
        buffer.append(":");
        buffer.append(StringUtil.fillLeft(Integer.toString(minutes), 2, '0'));
        buffer.append(":");
        buffer.append(StringUtil.fillLeft(Integer.toString(secounds), 2, '0'));
        buffer.append(".");
        buffer.append(StringUtil.fillLeft(Integer.toString(millisecounds), 3, '0'));
        return buffer.toString();
    }
}

