/*
 * Decompiled with CFR 0.152.
 */
package pl.com.kir.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import pl.com.kir.util.ByteArrayUtil;
import pl.com.kir.util.FileUtil;
import pl.com.kir.util.ParameterValidator;

public class StringUtil {
    public static final String END_LINE = "\r\n";
    public static final String EMPTY_STRING = "";
    public static final String HR20 = "--------------------";
    public static final String HR40 = "----------------------------------------";
    public static final String HR60 = "------------------------------------------------------------";
    public static final String HR80 = "--------------------------------------------------------------------------------";
    public static final String HR100 = "----------------------------------------------------------------------------------------------------";
    public static final String HR120 = "------------------------------------------------------------------------------------------------------------------------";
    public static final String HR160 = "----------------------------------------------------------------------------------------------------------------------------------------------------------------";
    public static final String HR200 = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final byte[] UNICODE_HEADER = new byte[]{-1, -2};
    private static final byte[] UTF8_HEADER = new byte[]{-17, -69, -65};

    private StringUtil() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    public static boolean equals(String s1, String s2, boolean empty) {
        if (empty) {
            if (s1 == null) {
                s1 = EMPTY_STRING;
            }
            if (s2 == null) {
                s2 = EMPTY_STRING;
            }
            return s1.equals(s2);
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String s1, String s2, boolean empty) {
        if (empty) {
            if (s1 == null) {
                s1 = EMPTY_STRING;
            }
            if (s2 == null) {
                s2 = EMPTY_STRING;
            }
            return s1.equalsIgnoreCase(s2);
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    public static boolean equals(String[] s1, String[] s2, boolean empty) {
        if (s1 == null || s2 == null) {
            throw new IllegalArgumentException("Argument is NULL");
        }
        boolean result = true;
        if (s1.length != s2.length) {
            result = false;
        } else {
            for (int i2 = 0; result && i2 < s1.length; ++i2) {
                result = StringUtil.equals(s1[i2], s2[i2], empty);
            }
        }
        return result;
    }

    public static boolean equalsIgnoreCase(String[] s1, String[] s2, boolean empty) {
        if (s1 == null || s2 == null) {
            throw new IllegalArgumentException("Argument is NULL");
        }
        boolean result = true;
        if (s1.length != s2.length) {
            result = false;
        } else {
            for (int i2 = 0; result && i2 < s1.length; ++i2) {
                result = StringUtil.equalsIgnoreCase(s1[i2], s2[i2], empty);
            }
        }
        return result;
    }

    public static String fillLeft(String value, int length, char ch) {
        String result = null;
        if (value != null) {
            result = value;
            while (result.length() < length) {
                result = ch + result;
            }
        }
        return result;
    }

    public static String fillRight(String value, int length, char ch) {
        String result = null;
        if (value != null) {
            result = value;
            while (result.length() < length) {
                result = result + ch;
            }
        }
        return result;
    }

    public static String replace(String value, String source, String target) {
        if (StringUtil.isEmpty(value) || StringUtil.isEmpty(source) || StringUtil.isEmpty(target)) {
            return value;
        }
        if (value.indexOf(source) >= 0) {
            StringBuffer result = new StringBuffer();
            int idx = -1;
            while ((idx = value.indexOf(source)) >= 0) {
                result.append(value.substring(0, idx));
                result.append(target);
                value = value.substring(idx + source.length());
            }
            result.append(value);
            return result.toString();
        }
        return value;
    }

    public static String replace(String mask, String[] params) {
        return StringUtil.replace(mask, "?", params);
    }

    public static String replace(String mask, String symbol, String[] params) {
        String result = mask;
        if (!StringUtil.isEmpty(mask) && !StringUtil.isEmpty(symbol)) {
            for (int i2 = 0; params != null && i2 < params.length; ++i2) {
                int idx = result.indexOf(symbol);
                if (idx < 0) continue;
                result = result.substring(0, idx) + params[i2] + result.substring(idx + symbol.length(), result.length());
            }
        }
        return result;
    }

    public static String replace(String mask, String[][] params) {
        String result = mask;
        if (!StringUtil.isEmpty(mask)) {
            for (int i2 = 0; params != null && i2 < params.length && params[i2].length >= 2; ++i2) {
                String param = params[i2][0];
                String value = params[i2][1];
                result = result.replace(param, value);
            }
        }
        return result;
    }

    public static String encodeUTF(String value) {
        if (StringUtil.isEmpty(value)) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char ch = value.charAt(i2);
            char code = ch;
            if (code <= '\u007f') {
                result.append(ch);
                continue;
            }
            String hex = Integer.toHexString(code);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            result.append("\\u");
            result.append(hex);
        }
        return result.toString();
    }

    public static String decodeUTF(String value) {
        if (StringUtil.isEmpty(value)) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        int idx = -1;
        while ((idx = value.indexOf("\\u")) >= 0) {
            result.append(value.substring(0, idx));
            String hex = value.substring(idx + 2, idx + 6);
            int code = Integer.parseInt(hex, 16);
            char ch = (char)code;
            result.append(ch);
            value = value.substring(idx + 6);
        }
        result.append(value);
        return result.toString();
    }

    public static int search(String[] array, String value) {
        int result = -1;
        if (array != null && array.length > 0 && value != null) {
            for (int i2 = 0; result == -1 && i2 < array.length; ++i2) {
                if (!value.equals(array[i2])) continue;
                result = i2;
            }
        }
        return result;
    }

    public static String left(String value, int length) {
        ParameterValidator.assertNotNull("value", value);
        ParameterValidator.assertRange("length", length, 0, Integer.MAX_VALUE);
        String result = null;
        result = length >= value.length() ? value : value.substring(0, length);
        return result;
    }

    public static String right(String value, int length) {
        ParameterValidator.assertNotNull("value", value);
        ParameterValidator.assertRange("length", length, 0, Integer.MAX_VALUE);
        String result = null;
        result = length >= value.length() ? value : value.substring(value.length() - length);
        return result;
    }

    public static String[] toTokenArray(String value, String tokenSeparator) {
        String[] result = null;
        if (StringUtil.isEmpty(tokenSeparator)) {
            throw new IllegalArgumentException("Argument 'tokenSeparator' is empty");
        }
        if (value != null) {
            List<String> list = StringUtil.toTokenList(value, tokenSeparator);
            result = list.toArray(new String[list.size()]);
        }
        return result;
    }

    public static String[] toTokenArray(String value, int tokenSize) {
        String[] result = null;
        if (tokenSize <= 0) {
            throw new IllegalArgumentException("Argument 'tokenSize' <= 0");
        }
        if (value != null) {
            List<String> list = StringUtil.toTokenList(value, tokenSize);
            result = list.toArray(new String[list.size()]);
        }
        return result;
    }

    public static List<String> toTokenList(String value, String tokenSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtil.isEmpty(tokenSeparator)) {
            throw new IllegalArgumentException("Argument 'tokenSeparator' is empty");
        }
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, tokenSeparator);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
        }
        return result;
    }

    public static List<String> toTokenList(String value, int tokenSize) {
        ArrayList<String> result = new ArrayList<String>();
        if (tokenSize <= 0) {
            throw new IllegalArgumentException("Argument 'tokenSize' <= 0");
        }
        if (value != null) {
            while (value.length() > 0) {
                if (value.length() >= tokenSize) {
                    result.add(value.substring(0, tokenSize));
                    value = value.substring(tokenSize);
                    continue;
                }
                result.add(value);
                value = EMPTY_STRING;
            }
        }
        return result;
    }

    public static String toString(byte[] content) {
        String result = null;
        if (content != null) {
            try {
                result = content.length >= 2 && content[0] == UNICODE_HEADER[0] && content[1] == UNICODE_HEADER[1] ? new String(content, "Unicode") : (content.length >= 3 && content[0] == UTF8_HEADER[0] && content[1] == UTF8_HEADER[1] && content[2] == UTF8_HEADER[2] ? new String(content, 3, content.length - 3, "UTF-8") : new String(content, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                result = new String(content);
            }
        }
        return result;
    }

    public static String toString(String[] array, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; array != null && i2 < array.length; ++i2) {
            if (i2 > 0) {
                result.append(separator);
            }
            result.append(array[i2]);
        }
        return result.toString();
    }

    public static String toString(List<String> list, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; list != null && i2 < list.size(); ++i2) {
            if (i2 > 0) {
                result.append(separator);
            }
            result.append(list.get(i2));
        }
        return result.toString();
    }

    public static byte[] toByteArray(String content, String charsetName) throws UnsupportedEncodingException {
        byte[] result = null;
        if (content != null) {
            result = content.length() == 0 ? new byte[]{} : (charsetName == null ? content.getBytes() : (charsetName.equalsIgnoreCase("Unicode") ? content.getBytes(charsetName) : (charsetName.equalsIgnoreCase("UTF-8") || charsetName.equalsIgnoreCase("UTF8") ? ByteArrayUtil.sum(UTF8_HEADER, content.getBytes(charsetName)) : content.getBytes(charsetName))));
        }
        return result;
    }

    public static String firstUpperCase(String value) {
        String result = null;
        result = StringUtil.isEmpty(value) ? value : Character.toUpperCase(value.charAt(0)) + value.substring(1);
        return result;
    }

    public static String firstLowerCase(String value) {
        String result = null;
        result = StringUtil.isEmpty(value) ? value : Character.toLowerCase(value.charAt(0)) + value.substring(1);
        return result;
    }

    public static byte[] compress(String text) {
        if (text == null) {
            return null;
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(buffer);
            out.write(text.getBytes());
            out.flush();
            out.close();
            return buffer.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decompress(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            GZIPInputStream in = new GZIPInputStream(is);
            byte[] data = FileUtil.loadFile(in);
            return new String(data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String[] sum(String[] array, String value) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i2 = 0; array != null && i2 < array.length; ++i2) {
            resultList.add(array[i2]);
        }
        if (!StringUtil.isEmpty(value)) {
            resultList.add(value);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new String[resultList.size()]);
        }
        return null;
    }

    public static String[] sum(String[] x2, String[] y2) {
        int i2;
        ArrayList<String> resultList = new ArrayList<String>();
        for (i2 = 0; x2 != null && i2 < x2.length; ++i2) {
            resultList.add(x2[i2]);
        }
        for (i2 = 0; y2 != null && i2 < y2.length; ++i2) {
            resultList.add(y2[i2]);
        }
        if (resultList.size() > 0) {
            return resultList.toArray(new String[resultList.size()]);
        }
        return null;
    }
}

